@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.scheduler.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property hours Gets or sets the hours of the day that the job should execute at.
 * @property minutes Gets or sets the minutes of the hour that the job should execute at.
 * @property monthDays Gets or sets the days of the month that the job should execute on. Must be between 1 and 31.
 * @property monthlyOccurrences Gets or sets the occurrences of days within a month.
 * @property weekDays Gets or sets the days of the week that the job should execute on.
 */
public data class JobRecurrenceScheduleResponse(
    public val hours: List<Int>? = null,
    public val minutes: List<Int>? = null,
    public val monthDays: List<Int>? = null,
    public val monthlyOccurrences: List<JobRecurrenceScheduleMonthlyOccurrenceResponse>? = null,
    public val weekDays: List<String>? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.scheduler.outputs.JobRecurrenceScheduleResponse): JobRecurrenceScheduleResponse = JobRecurrenceScheduleResponse(
            hours = javaType.hours().map({ args0 -> args0 }),
            minutes = javaType.minutes().map({ args0 -> args0 }),
            monthDays = javaType.monthDays().map({ args0 -> args0 }),
            monthlyOccurrences = javaType.monthlyOccurrences().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.scheduler.kotlin.outputs.JobRecurrenceScheduleMonthlyOccurrenceResponse.Companion.toKotlin(args0)
                })
            }),
            weekDays = javaType.weekDays().map({ args0 -> args0 }),
        )
    }
}
