@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.scheduler.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property executionCount Gets the number of times this job has executed.
 * @property failureCount Gets the number of times this job has failed.
 * @property faultedCount Gets the number of faulted occurrences (occurrences that were retried and failed as many times as the retry policy states).
 * @property lastExecutionTime Gets the time the last occurrence executed in ISO-8601 format.  Could be empty if job has not run yet.
 * @property nextExecutionTime Gets the time of the next occurrence in ISO-8601 format. Could be empty if the job is completed.
 */
public data class JobStatusResponse(
    public val executionCount: Int,
    public val failureCount: Int,
    public val faultedCount: Int,
    public val lastExecutionTime: String,
    public val nextExecutionTime: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.scheduler.outputs.JobStatusResponse): JobStatusResponse = JobStatusResponse(
            executionCount = javaType.executionCount(),
            failureCount = javaType.failureCount(),
            faultedCount = javaType.faultedCount(),
            lastExecutionTime = javaType.lastExecutionTime(),
            nextExecutionTime = javaType.nextExecutionTime(),
        )
    }
}
