@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.scheduler.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property audience Gets or sets the audience.
 * @property clientId Gets or sets the client identifier.
 * @property secret Gets or sets the secret, return value will always be empty.
 * @property tenant Gets or sets the tenant.
 * @property type Gets or sets the HTTP authentication type.
 * Expected value is 'ActiveDirectoryOAuth'.
 */
public data class OAuthAuthenticationResponse(
    public val audience: String? = null,
    public val clientId: String? = null,
    public val secret: String? = null,
    public val tenant: String? = null,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.scheduler.outputs.OAuthAuthenticationResponse): OAuthAuthenticationResponse = OAuthAuthenticationResponse(
            audience = javaType.audience().map({ args0 -> args0 }).orElse(null),
            clientId = javaType.clientId().map({ args0 -> args0 }).orElse(null),
            secret = javaType.secret().map({ args0 -> args0 }).orElse(null),
            tenant = javaType.tenant().map({ args0 -> args0 }).orElse(null),
            type = javaType.type(),
        )
    }
}
