@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.scheduler.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property retryCount Gets or sets the number of times a retry should be attempted.
 * @property retryInterval Gets or sets the retry interval between retries, specify duration in ISO 8601 format.
 * @property retryType Gets or sets the retry strategy to be used.
 */
public data class RetryPolicyResponse(
    public val retryCount: Int? = null,
    public val retryInterval: String? = null,
    public val retryType: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.scheduler.outputs.RetryPolicyResponse): RetryPolicyResponse = RetryPolicyResponse(
            retryCount = javaType.retryCount().map({ args0 -> args0 }).orElse(null),
            retryInterval = javaType.retryInterval().map({ args0 -> args0 }).orElse(null),
            retryType = javaType.retryType().map({ args0 -> args0 }).orElse(null),
        )
    }
}
