@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.scheduler.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property sasKey Gets or sets the SAS key.
 * @property sasKeyName Gets or sets the SAS key name.
 * @property type Gets or sets the authentication type.
 */
public data class ServiceBusAuthenticationResponse(
    public val sasKey: String? = null,
    public val sasKeyName: String? = null,
    public val type: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.scheduler.outputs.ServiceBusAuthenticationResponse): ServiceBusAuthenticationResponse = ServiceBusAuthenticationResponse(
            sasKey = javaType.sasKey().map({ args0 -> args0 }).orElse(null),
            sasKeyName = javaType.sasKeyName().map({ args0 -> args0 }).orElse(null),
            type = javaType.type().map({ args0 -> args0 }).orElse(null),
        )
    }
}
