@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.scheduler.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property contentType Gets or sets the content type.
 * @property correlationId Gets or sets the correlation ID.
 * @property forcePersistence Gets or sets the force persistence.
 * @property label Gets or sets the label.
 * @property messageId Gets or sets the message ID.
 * @property partitionKey Gets or sets the partition key.
 * @property replyTo Gets or sets the reply to.
 * @property replyToSessionId Gets or sets the reply to session ID.
 * @property scheduledEnqueueTimeUtc Gets or sets the scheduled enqueue time UTC.
 * @property sessionId Gets or sets the session ID.
 * @property timeToLive Gets or sets the time to live.
 * @property to Gets or sets the to.
 * @property viaPartitionKey Gets or sets the via partition key.
 */
public data class ServiceBusBrokeredMessagePropertiesResponse(
    public val contentType: String? = null,
    public val correlationId: String? = null,
    public val forcePersistence: Boolean? = null,
    public val label: String? = null,
    public val messageId: String? = null,
    public val partitionKey: String? = null,
    public val replyTo: String? = null,
    public val replyToSessionId: String? = null,
    public val scheduledEnqueueTimeUtc: String? = null,
    public val sessionId: String? = null,
    public val timeToLive: String? = null,
    public val to: String? = null,
    public val viaPartitionKey: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.scheduler.outputs.ServiceBusBrokeredMessagePropertiesResponse): ServiceBusBrokeredMessagePropertiesResponse = ServiceBusBrokeredMessagePropertiesResponse(
            contentType = javaType.contentType().map({ args0 -> args0 }).orElse(null),
            correlationId = javaType.correlationId().map({ args0 -> args0 }).orElse(null),
            forcePersistence = javaType.forcePersistence().map({ args0 -> args0 }).orElse(null),
            label = javaType.label().map({ args0 -> args0 }).orElse(null),
            messageId = javaType.messageId().map({ args0 -> args0 }).orElse(null),
            partitionKey = javaType.partitionKey().map({ args0 -> args0 }).orElse(null),
            replyTo = javaType.replyTo().map({ args0 -> args0 }).orElse(null),
            replyToSessionId = javaType.replyToSessionId().map({ args0 -> args0 }).orElse(null),
            scheduledEnqueueTimeUtc = javaType.scheduledEnqueueTimeUtc().map({ args0 -> args0 }).orElse(null),
            sessionId = javaType.sessionId().map({ args0 -> args0 }).orElse(null),
            timeToLive = javaType.timeToLive().map({ args0 -> args0 }).orElse(null),
            to = javaType.to().map({ args0 -> args0 }).orElse(null),
            viaPartitionKey = javaType.viaPartitionKey().map({ args0 -> args0 }).orElse(null),
        )
    }
}
