@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.scom.kotlin

import com.pulumi.azurenative.scom.kotlin.outputs.ManagedGatewayPropertiesResponse
import com.pulumi.azurenative.scom.kotlin.outputs.SystemDataResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import com.pulumi.azurenative.scom.kotlin.outputs.ManagedGatewayPropertiesResponse.Companion.toKotlin as managedGatewayPropertiesResponseToKotlin
import com.pulumi.azurenative.scom.kotlin.outputs.SystemDataResponse.Companion.toKotlin as systemDataResponseToKotlin

/**
 * Builder for [ManagedGateway].
 */
@PulumiTagMarker
public class ManagedGatewayResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ManagedGatewayArgs = ManagedGatewayArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ManagedGatewayArgsBuilder.() -> Unit) {
        val builder = ManagedGatewayArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): ManagedGateway {
        val builtJavaResource = com.pulumi.azurenative.scom.ManagedGateway(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return ManagedGateway(builtJavaResource)
    }
}

/**
 * A gateway resource.
 * Azure REST API version: 2023-07-07-preview.
 * ## Example Usage
 * ### ManagedGateway_CreateOrUpdate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var managedGateway = new AzureNative.Scom.ManagedGateway("managedGateway", new()
 *     {
 *         InstanceName = "myInstance",
 *         ManagedGatewayName = "d877b154-9a8d-4bfe-8a24-20682fcf2ed3",
 *         ResourceGroupName = "myResGroup",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/scom/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := scom.NewManagedGateway(ctx, "managedGateway", &scom.ManagedGatewayArgs{
 * 			InstanceName:       pulumi.String("myInstance"),
 * 			ManagedGatewayName: pulumi.String("d877b154-9a8d-4bfe-8a24-20682fcf2ed3"),
 * 			ResourceGroupName:  pulumi.String("myResGroup"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.scom.ManagedGateway;
 * import com.pulumi.azurenative.scom.ManagedGatewayArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var managedGateway = new ManagedGateway("managedGateway", ManagedGatewayArgs.builder()
 *             .instanceName("myInstance")
 *             .managedGatewayName("d877b154-9a8d-4bfe-8a24-20682fcf2ed3")
 *             .resourceGroupName("myResGroup")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:scom:ManagedGateway d877b154-9a8d-4bfe-8a24-20682fcf2ed3 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Scom/managedInstances/{instanceName}/managedGateways/{managedGatewayName}
 * ```
 */
public class ManagedGateway internal constructor(
    override val javaResource: com.pulumi.azurenative.scom.ManagedGateway,
) : KotlinCustomResource(javaResource, ManagedGatewayMapper) {
    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The properties of a gateway resource.
     */
    public val properties: Output<ManagedGatewayPropertiesResponse>
        get() = javaResource.properties().applyValue({ args0 ->
            args0.let({ args0 ->
                managedGatewayPropertiesResponseToKotlin(args0)
            })
        })

    /**
     * Azure Resource Manager metadata containing createdBy and modifiedBy information.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.let({ args0 ->
                systemDataResponseToKotlin(args0)
            })
        })

    /**
     * The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object ManagedGatewayMapper : ResourceMapper<ManagedGateway> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.scom.ManagedGateway::class == javaResource::class

    override fun map(javaResource: Resource): ManagedGateway = ManagedGateway(
        javaResource as
            com.pulumi.azurenative.scom.ManagedGateway,
    )
}

/**
 * @see [ManagedGateway].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [ManagedGateway].
 */
public suspend fun managedGateway(
    name: String,
    block: suspend ManagedGatewayResourceBuilder.() -> Unit,
): ManagedGateway {
    val builder = ManagedGatewayResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [ManagedGateway].
 * @param name The _unique_ name of the resulting resource.
 */
public fun managedGateway(name: String): ManagedGateway {
    val builder = ManagedGatewayResourceBuilder()
    builder.name(name)
    return builder.build()
}
