@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.scom.kotlin

import com.pulumi.azurenative.scom.ManagedGatewayArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * A gateway resource.
 * Azure REST API version: 2023-07-07-preview.
 * ## Example Usage
 * ### ManagedGateway_CreateOrUpdate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var managedGateway = new AzureNative.Scom.ManagedGateway("managedGateway", new()
 *     {
 *         InstanceName = "myInstance",
 *         ManagedGatewayName = "d877b154-9a8d-4bfe-8a24-20682fcf2ed3",
 *         ResourceGroupName = "myResGroup",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/scom/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := scom.NewManagedGateway(ctx, "managedGateway", &scom.ManagedGatewayArgs{
 * 			InstanceName:       pulumi.String("myInstance"),
 * 			ManagedGatewayName: pulumi.String("d877b154-9a8d-4bfe-8a24-20682fcf2ed3"),
 * 			ResourceGroupName:  pulumi.String("myResGroup"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.scom.ManagedGateway;
 * import com.pulumi.azurenative.scom.ManagedGatewayArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var managedGateway = new ManagedGateway("managedGateway", ManagedGatewayArgs.builder()
 *             .instanceName("myInstance")
 *             .managedGatewayName("d877b154-9a8d-4bfe-8a24-20682fcf2ed3")
 *             .resourceGroupName("myResGroup")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:scom:ManagedGateway d877b154-9a8d-4bfe-8a24-20682fcf2ed3 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Scom/managedInstances/{instanceName}/managedGateways/{managedGatewayName}
 * ```
 * @property instanceName Name of the SCOM managed instance.
 * @property managedGatewayName The gateway resource name.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 */
public data class ManagedGatewayArgs(
    public val instanceName: Output<String>? = null,
    public val managedGatewayName: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.scom.ManagedGatewayArgs> {
    override fun toJava(): com.pulumi.azurenative.scom.ManagedGatewayArgs =
        com.pulumi.azurenative.scom.ManagedGatewayArgs.builder()
            .instanceName(instanceName?.applyValue({ args0 -> args0 }))
            .managedGatewayName(managedGatewayName?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ManagedGatewayArgs].
 */
@PulumiTagMarker
public class ManagedGatewayArgsBuilder internal constructor() {
    private var instanceName: Output<String>? = null

    private var managedGatewayName: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    /**
     * @param value Name of the SCOM managed instance.
     */
    @JvmName("frenfwgfqwvtysfa")
    public suspend fun instanceName(`value`: Output<String>) {
        this.instanceName = value
    }

    /**
     * @param value The gateway resource name.
     */
    @JvmName("wmjlxrrpojycvptj")
    public suspend fun managedGatewayName(`value`: Output<String>) {
        this.managedGatewayName = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("rsvbqcqrqlkglmkv")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Name of the SCOM managed instance.
     */
    @JvmName("povelbtqhimtqhts")
    public suspend fun instanceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.instanceName = mapped
    }

    /**
     * @param value The gateway resource name.
     */
    @JvmName("mifjfcrtilkyenmf")
    public suspend fun managedGatewayName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.managedGatewayName = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("qnslfvqccvhowxmr")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    internal fun build(): ManagedGatewayArgs = ManagedGatewayArgs(
        instanceName = instanceName,
        managedGatewayName = managedGatewayName,
        resourceGroupName = resourceGroupName,
    )
}
