@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.scom.kotlin

import com.pulumi.azurenative.scom.MonitoredResourceArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * A monitored resource.
 * Azure REST API version: 2023-07-07-preview.
 * ## Example Usage
 * ### MonitoredResources_CreateOrUpdate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var monitoredResource = new AzureNative.Scom.MonitoredResource("monitoredResource", new()
 *     {
 *         InstanceName = "myInstance",
 *         MonitoredResourceName = "d877b154-9a8d-4bfe-8a24-20682fcf2ed3",
 *         ResourceGroupName = "myResGroup",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/scom/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := scom.NewMonitoredResource(ctx, "monitoredResource", &scom.MonitoredResourceArgs{
 * 			InstanceName:          pulumi.String("myInstance"),
 * 			MonitoredResourceName: pulumi.String("d877b154-9a8d-4bfe-8a24-20682fcf2ed3"),
 * 			ResourceGroupName:     pulumi.String("myResGroup"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.scom.MonitoredResource;
 * import com.pulumi.azurenative.scom.MonitoredResourceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var monitoredResource = new MonitoredResource("monitoredResource", MonitoredResourceArgs.builder()
 *             .instanceName("myInstance")
 *             .monitoredResourceName("d877b154-9a8d-4bfe-8a24-20682fcf2ed3")
 *             .resourceGroupName("myResGroup")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:scom:MonitoredResource d877b154-9a8d-4bfe-8a24-20682fcf2ed3 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Scom/managedInstances/{instanceName}/monitoredResources/{monitoredResourceName}
 * ```
 * @property instanceName Name of the SCOM managed instance.
 * @property monitoredResourceName The monitored resource name.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 */
public data class MonitoredResourceArgs(
    public val instanceName: Output<String>? = null,
    public val monitoredResourceName: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.scom.MonitoredResourceArgs> {
    override fun toJava(): com.pulumi.azurenative.scom.MonitoredResourceArgs =
        com.pulumi.azurenative.scom.MonitoredResourceArgs.builder()
            .instanceName(instanceName?.applyValue({ args0 -> args0 }))
            .monitoredResourceName(monitoredResourceName?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [MonitoredResourceArgs].
 */
@PulumiTagMarker
public class MonitoredResourceArgsBuilder internal constructor() {
    private var instanceName: Output<String>? = null

    private var monitoredResourceName: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    /**
     * @param value Name of the SCOM managed instance.
     */
    @JvmName("uctiafyapicknmop")
    public suspend fun instanceName(`value`: Output<String>) {
        this.instanceName = value
    }

    /**
     * @param value The monitored resource name.
     */
    @JvmName("uehfctvkakspwgja")
    public suspend fun monitoredResourceName(`value`: Output<String>) {
        this.monitoredResourceName = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("dgmynxddqpsysjrg")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Name of the SCOM managed instance.
     */
    @JvmName("kuucohlyapvdrjxp")
    public suspend fun instanceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.instanceName = mapped
    }

    /**
     * @param value The monitored resource name.
     */
    @JvmName("cuaiqefpniivoaon")
    public suspend fun monitoredResourceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.monitoredResourceName = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("jyniqaiurwtjhveu")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    internal fun build(): MonitoredResourceArgs = MonitoredResourceArgs(
        instanceName = instanceName,
        monitoredResourceName = monitoredResourceName,
        resourceGroupName = resourceGroupName,
    )
}
