@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.scom.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * Specifies that the image or disk that is being used was licensed on-premises. <br><br> For more information, see [Azure Hybrid Use Benefit for Windows Server](https://docs.microsoft.com/azure/virtual-machines/virtual-machines-windows-hybrid-use-benefit-licensing?toc=%2fazure%2fvirtual-machines%2fwindows%2ftoc.json)
 */
public enum class HybridLicenseType(
    public val javaValue: com.pulumi.azurenative.scom.enums.HybridLicenseType,
) : ConvertibleToJava<com.pulumi.azurenative.scom.enums.HybridLicenseType> {
    None(com.pulumi.azurenative.scom.enums.HybridLicenseType.None),
    AzureHybridBenefit(com.pulumi.azurenative.scom.enums.HybridLicenseType.AzureHybridBenefit),
    ;

    override fun toJava(): com.pulumi.azurenative.scom.enums.HybridLicenseType = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.scom.enums.HybridLicenseType): HybridLicenseType = HybridLicenseType.values().first { it.javaValue == javaType }
    }
}
