@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.scom.kotlin.inputs

import com.pulumi.azurenative.scom.inputs.DatabaseInstancePropertiesArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * The properties of database instance
 * @property databaseInstanceId Resource Id of existing database instance
 */
public data class DatabaseInstancePropertiesArgs(
    public val databaseInstanceId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.scom.inputs.DatabaseInstancePropertiesArgs> {
    override fun toJava(): com.pulumi.azurenative.scom.inputs.DatabaseInstancePropertiesArgs =
        com.pulumi.azurenative.scom.inputs.DatabaseInstancePropertiesArgs.builder()
            .databaseInstanceId(databaseInstanceId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [DatabaseInstancePropertiesArgs].
 */
@PulumiTagMarker
public class DatabaseInstancePropertiesArgsBuilder internal constructor() {
    private var databaseInstanceId: Output<String>? = null

    /**
     * @param value Resource Id of existing database instance
     */
    @JvmName("jxrpwemtyfceqhwu")
    public suspend fun databaseInstanceId(`value`: Output<String>) {
        this.databaseInstanceId = value
    }

    /**
     * @param value Resource Id of existing database instance
     */
    @JvmName("loxalufigeinsowx")
    public suspend fun databaseInstanceId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.databaseInstanceId = mapped
    }

    internal fun build(): DatabaseInstancePropertiesArgs = DatabaseInstancePropertiesArgs(
        databaseInstanceId = databaseInstanceId,
    )
}
