@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.scom.kotlin.inputs

import com.pulumi.azurenative.scom.inputs.DomainControllerPropertiesArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * The properties of domain controller to which SCOM and SQL servers join for AuthN/AuthZ.
 * @property dnsServer IP address of DNS server
 * @property domainName Fully qualified domain name
 * @property ouPath Organizational Unit path in which the SCOM servers will be present
 */
public data class DomainControllerPropertiesArgs(
    public val dnsServer: Output<String>? = null,
    public val domainName: Output<String>? = null,
    public val ouPath: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.scom.inputs.DomainControllerPropertiesArgs> {
    override fun toJava(): com.pulumi.azurenative.scom.inputs.DomainControllerPropertiesArgs =
        com.pulumi.azurenative.scom.inputs.DomainControllerPropertiesArgs.builder()
            .dnsServer(dnsServer?.applyValue({ args0 -> args0 }))
            .domainName(domainName?.applyValue({ args0 -> args0 }))
            .ouPath(ouPath?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [DomainControllerPropertiesArgs].
 */
@PulumiTagMarker
public class DomainControllerPropertiesArgsBuilder internal constructor() {
    private var dnsServer: Output<String>? = null

    private var domainName: Output<String>? = null

    private var ouPath: Output<String>? = null

    /**
     * @param value IP address of DNS server
     */
    @JvmName("huucpaanhcivxhgi")
    public suspend fun dnsServer(`value`: Output<String>) {
        this.dnsServer = value
    }

    /**
     * @param value Fully qualified domain name
     */
    @JvmName("rbvydnlinvdgtqid")
    public suspend fun domainName(`value`: Output<String>) {
        this.domainName = value
    }

    /**
     * @param value Organizational Unit path in which the SCOM servers will be present
     */
    @JvmName("bkuiyjboujxaxrcb")
    public suspend fun ouPath(`value`: Output<String>) {
        this.ouPath = value
    }

    /**
     * @param value IP address of DNS server
     */
    @JvmName("hwsxjrtmfbdapajp")
    public suspend fun dnsServer(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dnsServer = mapped
    }

    /**
     * @param value Fully qualified domain name
     */
    @JvmName("qkgwgwywcixnuqjo")
    public suspend fun domainName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.domainName = mapped
    }

    /**
     * @param value Organizational Unit path in which the SCOM servers will be present
     */
    @JvmName("fpuwcmabfujxmfio")
    public suspend fun ouPath(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ouPath = mapped
    }

    internal fun build(): DomainControllerPropertiesArgs = DomainControllerPropertiesArgs(
        dnsServer = dnsServer,
        domainName = domainName,
        ouPath = ouPath,
    )
}
