@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.scom.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * The properties of database instance
 * @property databaseFqdn Fully qualified domain name of existing database instance
 * @property databaseInstanceId Resource Id of existing database instance
 * @property dwDatabaseId Resource Id of warehouse database on database instance
 * @property dwDatabaseName Name of warehouse database on database instance
 * @property operationalDatabaseId Resource Id of operational database on database instance
 */
public data class DatabaseInstancePropertiesResponse(
    public val databaseFqdn: String,
    public val databaseInstanceId: String? = null,
    public val dwDatabaseId: String,
    public val dwDatabaseName: String,
    public val operationalDatabaseId: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.scom.outputs.DatabaseInstancePropertiesResponse): DatabaseInstancePropertiesResponse = DatabaseInstancePropertiesResponse(
            databaseFqdn = javaType.databaseFqdn(),
            databaseInstanceId = javaType.databaseInstanceId().map({ args0 -> args0 }).orElse(null),
            dwDatabaseId = javaType.dwDatabaseId(),
            dwDatabaseName = javaType.dwDatabaseName(),
            operationalDatabaseId = javaType.operationalDatabaseId(),
        )
    }
}
