@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.scom.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * The properties of domain controller to which SCOM and SQL servers join for AuthN/AuthZ.
 * @property dnsServer IP address of DNS server
 * @property domainName Fully qualified domain name
 * @property ouPath Organizational Unit path in which the SCOM servers will be present
 */
public data class DomainControllerPropertiesResponse(
    public val dnsServer: String? = null,
    public val domainName: String? = null,
    public val ouPath: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.scom.outputs.DomainControllerPropertiesResponse): DomainControllerPropertiesResponse = DomainControllerPropertiesResponse(
            dnsServer = javaType.dnsServer().map({ args0 -> args0 }).orElse(null),
            domainName = javaType.domainName().map({ args0 -> args0 }).orElse(null),
            ouPath = javaType.ouPath().map({ args0 -> args0 }).orElse(null),
        )
    }
}
