@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.scom.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Gmsa Details
 * @property dnsName Frontend DNS name for Load Balancer which will be used by Agents to initiate communication
 * @property gmsaAccount gMSA account under which context all Management Server services will run
 * @property loadBalancerIP Frontend IP configuration for Load Balancer, which should be an available IP in customer VNet
 * @property managementServerGroupName OnPrem AD Computer Group where we will join VMs for ease of management
 */
public data class GmsaDetailsResponse(
    public val dnsName: String? = null,
    public val gmsaAccount: String? = null,
    public val loadBalancerIP: String? = null,
    public val managementServerGroupName: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.scom.outputs.GmsaDetailsResponse): GmsaDetailsResponse = GmsaDetailsResponse(
            dnsName = javaType.dnsName().map({ args0 -> args0 }).orElse(null),
            gmsaAccount = javaType.gmsaAccount().map({ args0 -> args0 }).orElse(null),
            loadBalancerIP = javaType.loadBalancerIP().map({ args0 -> args0 }).orElse(null),
            managementServerGroupName = javaType.managementServerGroupName().map({ args0 ->
                args0
            }).orElse(null),
        )
    }
}
