@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.scom.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Gets status of current and latest SCOM managed instance operation.
 * @property id Operation id
 * @property operationName Operation Name
 * @property operationState Operation status
 */
public data class ManagedInstanceOperationStatusResponse(
    public val id: String,
    public val operationName: String,
    public val operationState: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.scom.outputs.ManagedInstanceOperationStatusResponse): ManagedInstanceOperationStatusResponse = ManagedInstanceOperationStatusResponse(
            id = javaType.id(),
            operationName = javaType.operationName(),
            operationState = javaType.operationState(),
        )
    }
}
