@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.scom.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * The properties of management server
 * @property fqdn Management server Fully Qualified Domain Name.
 * @property healthState Management server health state.
 * @property serverName Management server Name
 * @property serverRoles Represent whether the Server is a Management Server and/or Web Console Server.
 * @property vmResId Azure VM Resource Id of the Management server.
 */
public data class ManagementServerPropertiesResponse(
    public val fqdn: String,
    public val healthState: String,
    public val serverName: String,
    public val serverRoles: String,
    public val vmResId: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.scom.outputs.ManagementServerPropertiesResponse): ManagementServerPropertiesResponse = ManagementServerPropertiesResponse(
            fqdn = javaType.fqdn(),
            healthState = javaType.healthState(),
            serverName = javaType.serverName(),
            serverRoles = javaType.serverRoles(),
            vmResId = javaType.vmResId(),
        )
    }
}
