@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.scvmm.kotlin

import com.pulumi.azurenative.scvmm.kotlin.outputs.GuestCredentialResponse
import com.pulumi.azurenative.scvmm.kotlin.outputs.HttpProxyConfigurationResponse
import com.pulumi.azurenative.scvmm.kotlin.outputs.SystemDataResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import com.pulumi.azurenative.scvmm.kotlin.outputs.GuestCredentialResponse.Companion.toKotlin as guestCredentialResponseToKotlin
import com.pulumi.azurenative.scvmm.kotlin.outputs.HttpProxyConfigurationResponse.Companion.toKotlin as httpProxyConfigurationResponseToKotlin
import com.pulumi.azurenative.scvmm.kotlin.outputs.SystemDataResponse.Companion.toKotlin as systemDataResponseToKotlin

/**
 * Builder for [GuestAgent].
 */
@PulumiTagMarker
public class GuestAgentResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: GuestAgentArgs = GuestAgentArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend GuestAgentArgsBuilder.() -> Unit) {
        val builder = GuestAgentArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): GuestAgent {
        val builtJavaResource = com.pulumi.azurenative.scvmm.GuestAgent(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return GuestAgent(builtJavaResource)
    }
}

/**
 * Defines the GuestAgent.
 * Azure REST API version: 2022-05-21-preview.
 * Other available API versions: 2023-04-01-preview, 2023-10-07.
 * ## Example Usage
 * ### CreateGuestAgent
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var guestAgent = new AzureNative.ScVmm.GuestAgent("guestAgent", new()
 *     {
 *         Credentials = new AzureNative.ScVmm.Inputs.GuestCredentialArgs
 *         {
 *             Password = "<password>",
 *             Username = "tempuser",
 *         },
 *         GuestAgentName = "default",
 *         HttpProxyConfig = new AzureNative.ScVmm.Inputs.HttpProxyConfigurationArgs
 *         {
 *             HttpsProxy = "http://192.1.2.3:8080",
 *         },
 *         ProvisioningAction = AzureNative.ScVmm.ProvisioningAction.Install,
 *         ResourceGroupName = "testrg",
 *         VirtualMachineName = "ContosoVm",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/scvmm/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := scvmm.NewGuestAgent(ctx, "guestAgent", &scvmm.GuestAgentArgs{
 * 			Credentials: &scvmm.GuestCredentialArgs{
 * 				Password: pulumi.String("<password>"),
 * 				Username: pulumi.String("tempuser"),
 * 			},
 * 			GuestAgentName: pulumi.String("default"),
 * 			HttpProxyConfig: &scvmm.HttpProxyConfigurationArgs{
 * 				HttpsProxy: pulumi.String("http://192.1.2.3:8080"),
 * 			},
 * 			ProvisioningAction: pulumi.String(scvmm.ProvisioningActionInstall),
 * 			ResourceGroupName:  pulumi.String("testrg"),
 * 			VirtualMachineName: pulumi.String("ContosoVm"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.scvmm.GuestAgent;
 * import com.pulumi.azurenative.scvmm.GuestAgentArgs;
 * import com.pulumi.azurenative.scvmm.inputs.GuestCredentialArgs;
 * import com.pulumi.azurenative.scvmm.inputs.HttpProxyConfigurationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var guestAgent = new GuestAgent("guestAgent", GuestAgentArgs.builder()
 *             .credentials(GuestCredentialArgs.builder()
 *                 .password("<password>")
 *                 .username("tempuser")
 *                 .build())
 *             .guestAgentName("default")
 *             .httpProxyConfig(HttpProxyConfigurationArgs.builder()
 *                 .httpsProxy("http://192.1.2.3:8080")
 *                 .build())
 *             .provisioningAction("install")
 *             .resourceGroupName("testrg")
 *             .virtualMachineName("ContosoVm")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:scvmm:GuestAgent default /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ScVmm/virtualMachines/{virtualMachineName}/guestAgents/{guestAgentName}
 * ```
 */
public class GuestAgent internal constructor(
    override val javaResource: com.pulumi.azurenative.scvmm.GuestAgent,
) : KotlinCustomResource(javaResource, GuestAgentMapper) {
    /**
     * Username / Password Credentials to provision guest agent.
     */
    public val credentials: Output<GuestCredentialResponse>?
        get() = javaResource.credentials().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    guestCredentialResponseToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * Gets the name of the corresponding resource in Kubernetes.
     */
    public val customResourceName: Output<String>
        get() = javaResource.customResourceName().applyValue({ args0 -> args0 })

    /**
     * HTTP Proxy configuration for the VM.
     */
    public val httpProxyConfig: Output<HttpProxyConfigurationResponse>?
        get() = javaResource.httpProxyConfig().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> httpProxyConfigurationResponseToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Gets or sets the guest agent provisioning action.
     */
    public val provisioningAction: Output<String>?
        get() = javaResource.provisioningAction().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Gets or sets the provisioning state.
     */
    public val provisioningState: Output<String>
        get() = javaResource.provisioningState().applyValue({ args0 -> args0 })

    /**
     * Gets or sets the guest agent status.
     */
    public val status: Output<String>
        get() = javaResource.status().applyValue({ args0 -> args0 })

    /**
     * Azure Resource Manager metadata containing createdBy and modifiedBy information.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.let({ args0 ->
                systemDataResponseToKotlin(args0)
            })
        })

    /**
     * The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })

    /**
     * Gets or sets a unique identifier for this resource.
     */
    public val uuid: Output<String>
        get() = javaResource.uuid().applyValue({ args0 -> args0 })
}

public object GuestAgentMapper : ResourceMapper<GuestAgent> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.scvmm.GuestAgent::class == javaResource::class

    override fun map(javaResource: Resource): GuestAgent = GuestAgent(
        javaResource as
            com.pulumi.azurenative.scvmm.GuestAgent,
    )
}

/**
 * @see [GuestAgent].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [GuestAgent].
 */
public suspend fun guestAgent(name: String, block: suspend GuestAgentResourceBuilder.() -> Unit): GuestAgent {
    val builder = GuestAgentResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [GuestAgent].
 * @param name The _unique_ name of the resulting resource.
 */
public fun guestAgent(name: String): GuestAgent {
    val builder = GuestAgentResourceBuilder()
    builder.name(name)
    return builder.build()
}
