@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.scvmm.kotlin

import com.pulumi.azurenative.scvmm.kotlin.outputs.IdentityResponse
import com.pulumi.azurenative.scvmm.kotlin.outputs.SystemDataResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import com.pulumi.azurenative.scvmm.kotlin.outputs.IdentityResponse.Companion.toKotlin as identityResponseToKotlin
import com.pulumi.azurenative.scvmm.kotlin.outputs.SystemDataResponse.Companion.toKotlin as systemDataResponseToKotlin

/**
 * Builder for [HybridIdentityMetadata].
 */
@PulumiTagMarker
public class HybridIdentityMetadataResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: HybridIdentityMetadataArgs = HybridIdentityMetadataArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend HybridIdentityMetadataArgsBuilder.() -> Unit) {
        val builder = HybridIdentityMetadataArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): HybridIdentityMetadata {
        val builtJavaResource =
            com.pulumi.azurenative.scvmm.HybridIdentityMetadata(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return HybridIdentityMetadata(builtJavaResource)
    }
}

/**
 * Defines the HybridIdentityMetadata.
 * Azure REST API version: 2022-05-21-preview.
 * Other available API versions: 2023-04-01-preview.
 * ## Example Usage
 * ### CreateHybridIdentityMetadata
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var hybridIdentityMetadata = new AzureNative.ScVmm.HybridIdentityMetadata("hybridIdentityMetadata", new()
 *     {
 *         MetadataName = "default",
 *         PublicKey = "8ec7d60c-9700-40b1-8e6e-e5b2f6f477f2",
 *         ResourceGroupName = "testrg",
 *         ResourceUid = "f8b82dff-38ef-4220-99ef-d3a3f86ddc6c",
 *         VirtualMachineName = "ContosoVm",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/scvmm/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := scvmm.NewHybridIdentityMetadata(ctx, "hybridIdentityMetadata", &scvmm.HybridIdentityMetadataArgs{
 * 			MetadataName:       pulumi.String("default"),
 * 			PublicKey:          pulumi.String("8ec7d60c-9700-40b1-8e6e-e5b2f6f477f2"),
 * 			ResourceGroupName:  pulumi.String("testrg"),
 * 			ResourceUid:        pulumi.String("f8b82dff-38ef-4220-99ef-d3a3f86ddc6c"),
 * 			VirtualMachineName: pulumi.String("ContosoVm"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.scvmm.HybridIdentityMetadata;
 * import com.pulumi.azurenative.scvmm.HybridIdentityMetadataArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var hybridIdentityMetadata = new HybridIdentityMetadata("hybridIdentityMetadata", HybridIdentityMetadataArgs.builder()
 *             .metadataName("default")
 *             .publicKey("8ec7d60c-9700-40b1-8e6e-e5b2f6f477f2")
 *             .resourceGroupName("testrg")
 *             .resourceUid("f8b82dff-38ef-4220-99ef-d3a3f86ddc6c")
 *             .virtualMachineName("ContosoVm")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:scvmm:HybridIdentityMetadata default /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ScVmm/virtualMachines/{virtualMachineName}/hybridIdentityMetadata/{metadataName}
 * ```
 */
public class HybridIdentityMetadata internal constructor(
    override val javaResource: com.pulumi.azurenative.scvmm.HybridIdentityMetadata,
) : KotlinCustomResource(javaResource, HybridIdentityMetadataMapper) {
    /**
     * The identity of the resource.
     */
    public val identity: Output<IdentityResponse>
        get() = javaResource.identity().applyValue({ args0 ->
            args0.let({ args0 ->
                identityResponseToKotlin(args0)
            })
        })

    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Gets or sets the provisioning state.
     */
    public val provisioningState: Output<String>
        get() = javaResource.provisioningState().applyValue({ args0 -> args0 })

    /**
     * Gets or sets the Public Key.
     */
    public val publicKey: Output<String>?
        get() = javaResource.publicKey().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Gets or sets the Vm Id.
     */
    public val resourceUid: Output<String>?
        get() = javaResource.resourceUid().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Azure Resource Manager metadata containing createdBy and modifiedBy information.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.let({ args0 ->
                systemDataResponseToKotlin(args0)
            })
        })

    /**
     * The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object HybridIdentityMetadataMapper : ResourceMapper<HybridIdentityMetadata> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.scvmm.HybridIdentityMetadata::class == javaResource::class

    override fun map(javaResource: Resource): HybridIdentityMetadata =
        HybridIdentityMetadata(javaResource as com.pulumi.azurenative.scvmm.HybridIdentityMetadata)
}

/**
 * @see [HybridIdentityMetadata].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [HybridIdentityMetadata].
 */
public suspend fun hybridIdentityMetadata(
    name: String,
    block: suspend HybridIdentityMetadataResourceBuilder.() -> Unit,
): HybridIdentityMetadata {
    val builder = HybridIdentityMetadataResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [HybridIdentityMetadata].
 * @param name The _unique_ name of the resulting resource.
 */
public fun hybridIdentityMetadata(name: String): HybridIdentityMetadata {
    val builder = HybridIdentityMetadataResourceBuilder()
    builder.name(name)
    return builder.build()
}
