@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.scvmm.kotlin

import com.pulumi.azurenative.scvmm.HybridIdentityMetadataArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Defines the HybridIdentityMetadata.
 * Azure REST API version: 2022-05-21-preview.
 * Other available API versions: 2023-04-01-preview.
 * ## Example Usage
 * ### CreateHybridIdentityMetadata
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var hybridIdentityMetadata = new AzureNative.ScVmm.HybridIdentityMetadata("hybridIdentityMetadata", new()
 *     {
 *         MetadataName = "default",
 *         PublicKey = "8ec7d60c-9700-40b1-8e6e-e5b2f6f477f2",
 *         ResourceGroupName = "testrg",
 *         ResourceUid = "f8b82dff-38ef-4220-99ef-d3a3f86ddc6c",
 *         VirtualMachineName = "ContosoVm",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/scvmm/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := scvmm.NewHybridIdentityMetadata(ctx, "hybridIdentityMetadata", &scvmm.HybridIdentityMetadataArgs{
 * 			MetadataName:       pulumi.String("default"),
 * 			PublicKey:          pulumi.String("8ec7d60c-9700-40b1-8e6e-e5b2f6f477f2"),
 * 			ResourceGroupName:  pulumi.String("testrg"),
 * 			ResourceUid:        pulumi.String("f8b82dff-38ef-4220-99ef-d3a3f86ddc6c"),
 * 			VirtualMachineName: pulumi.String("ContosoVm"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.scvmm.HybridIdentityMetadata;
 * import com.pulumi.azurenative.scvmm.HybridIdentityMetadataArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var hybridIdentityMetadata = new HybridIdentityMetadata("hybridIdentityMetadata", HybridIdentityMetadataArgs.builder()
 *             .metadataName("default")
 *             .publicKey("8ec7d60c-9700-40b1-8e6e-e5b2f6f477f2")
 *             .resourceGroupName("testrg")
 *             .resourceUid("f8b82dff-38ef-4220-99ef-d3a3f86ddc6c")
 *             .virtualMachineName("ContosoVm")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:scvmm:HybridIdentityMetadata default /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ScVmm/virtualMachines/{virtualMachineName}/hybridIdentityMetadata/{metadataName}
 * ```
 * @property metadataName Name of the hybridIdentityMetadata.
 * @property publicKey Gets or sets the Public Key.
 * @property resourceGroupName The name of the resource group.
 * @property resourceUid Gets or sets the Vm Id.
 * @property virtualMachineName Name of the vm.
 */
public data class HybridIdentityMetadataArgs(
    public val metadataName: Output<String>? = null,
    public val publicKey: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val resourceUid: Output<String>? = null,
    public val virtualMachineName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.scvmm.HybridIdentityMetadataArgs> {
    override fun toJava(): com.pulumi.azurenative.scvmm.HybridIdentityMetadataArgs =
        com.pulumi.azurenative.scvmm.HybridIdentityMetadataArgs.builder()
            .metadataName(metadataName?.applyValue({ args0 -> args0 }))
            .publicKey(publicKey?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .resourceUid(resourceUid?.applyValue({ args0 -> args0 }))
            .virtualMachineName(virtualMachineName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [HybridIdentityMetadataArgs].
 */
@PulumiTagMarker
public class HybridIdentityMetadataArgsBuilder internal constructor() {
    private var metadataName: Output<String>? = null

    private var publicKey: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var resourceUid: Output<String>? = null

    private var virtualMachineName: Output<String>? = null

    /**
     * @param value Name of the hybridIdentityMetadata.
     */
    @JvmName("glsqdggxrtwoodtq")
    public suspend fun metadataName(`value`: Output<String>) {
        this.metadataName = value
    }

    /**
     * @param value Gets or sets the Public Key.
     */
    @JvmName("toqxkqrfteynwdtl")
    public suspend fun publicKey(`value`: Output<String>) {
        this.publicKey = value
    }

    /**
     * @param value The name of the resource group.
     */
    @JvmName("otgpiqndxyrdajpy")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Gets or sets the Vm Id.
     */
    @JvmName("xwinbrmecpbggerx")
    public suspend fun resourceUid(`value`: Output<String>) {
        this.resourceUid = value
    }

    /**
     * @param value Name of the vm.
     */
    @JvmName("vjqdmodhkhnomxae")
    public suspend fun virtualMachineName(`value`: Output<String>) {
        this.virtualMachineName = value
    }

    /**
     * @param value Name of the hybridIdentityMetadata.
     */
    @JvmName("kjilokmsqviaeayq")
    public suspend fun metadataName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.metadataName = mapped
    }

    /**
     * @param value Gets or sets the Public Key.
     */
    @JvmName("wyanyjorvhigupxf")
    public suspend fun publicKey(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.publicKey = mapped
    }

    /**
     * @param value The name of the resource group.
     */
    @JvmName("otadlfxpjqncqyge")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Gets or sets the Vm Id.
     */
    @JvmName("gcyittryepwdgkff")
    public suspend fun resourceUid(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceUid = mapped
    }

    /**
     * @param value Name of the vm.
     */
    @JvmName("bdmjgvoxdrhmhphb")
    public suspend fun virtualMachineName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.virtualMachineName = mapped
    }

    internal fun build(): HybridIdentityMetadataArgs = HybridIdentityMetadataArgs(
        metadataName = metadataName,
        publicKey = publicKey,
        resourceGroupName = resourceGroupName,
        resourceUid = resourceUid,
        virtualMachineName = virtualMachineName,
    )
}
