@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.scvmm.kotlin

import com.pulumi.azurenative.scvmm.ScvmmFunctions.getAvailabilitySetPlain
import com.pulumi.azurenative.scvmm.ScvmmFunctions.getCloudPlain
import com.pulumi.azurenative.scvmm.ScvmmFunctions.getGuestAgentPlain
import com.pulumi.azurenative.scvmm.ScvmmFunctions.getHybridIdentityMetadataPlain
import com.pulumi.azurenative.scvmm.ScvmmFunctions.getInventoryItemPlain
import com.pulumi.azurenative.scvmm.ScvmmFunctions.getMachineExtensionPlain
import com.pulumi.azurenative.scvmm.ScvmmFunctions.getVMInstanceGuestAgentPlain
import com.pulumi.azurenative.scvmm.ScvmmFunctions.getVirtualMachineInstancePlain
import com.pulumi.azurenative.scvmm.ScvmmFunctions.getVirtualMachinePlain
import com.pulumi.azurenative.scvmm.ScvmmFunctions.getVirtualMachineTemplatePlain
import com.pulumi.azurenative.scvmm.ScvmmFunctions.getVirtualNetworkPlain
import com.pulumi.azurenative.scvmm.ScvmmFunctions.getVmmServerPlain
import com.pulumi.azurenative.scvmm.kotlin.inputs.GetAvailabilitySetPlainArgs
import com.pulumi.azurenative.scvmm.kotlin.inputs.GetAvailabilitySetPlainArgsBuilder
import com.pulumi.azurenative.scvmm.kotlin.inputs.GetCloudPlainArgs
import com.pulumi.azurenative.scvmm.kotlin.inputs.GetCloudPlainArgsBuilder
import com.pulumi.azurenative.scvmm.kotlin.inputs.GetGuestAgentPlainArgs
import com.pulumi.azurenative.scvmm.kotlin.inputs.GetGuestAgentPlainArgsBuilder
import com.pulumi.azurenative.scvmm.kotlin.inputs.GetHybridIdentityMetadataPlainArgs
import com.pulumi.azurenative.scvmm.kotlin.inputs.GetHybridIdentityMetadataPlainArgsBuilder
import com.pulumi.azurenative.scvmm.kotlin.inputs.GetInventoryItemPlainArgs
import com.pulumi.azurenative.scvmm.kotlin.inputs.GetInventoryItemPlainArgsBuilder
import com.pulumi.azurenative.scvmm.kotlin.inputs.GetMachineExtensionPlainArgs
import com.pulumi.azurenative.scvmm.kotlin.inputs.GetMachineExtensionPlainArgsBuilder
import com.pulumi.azurenative.scvmm.kotlin.inputs.GetVMInstanceGuestAgentPlainArgs
import com.pulumi.azurenative.scvmm.kotlin.inputs.GetVMInstanceGuestAgentPlainArgsBuilder
import com.pulumi.azurenative.scvmm.kotlin.inputs.GetVirtualMachineInstancePlainArgs
import com.pulumi.azurenative.scvmm.kotlin.inputs.GetVirtualMachineInstancePlainArgsBuilder
import com.pulumi.azurenative.scvmm.kotlin.inputs.GetVirtualMachinePlainArgs
import com.pulumi.azurenative.scvmm.kotlin.inputs.GetVirtualMachinePlainArgsBuilder
import com.pulumi.azurenative.scvmm.kotlin.inputs.GetVirtualMachineTemplatePlainArgs
import com.pulumi.azurenative.scvmm.kotlin.inputs.GetVirtualMachineTemplatePlainArgsBuilder
import com.pulumi.azurenative.scvmm.kotlin.inputs.GetVirtualNetworkPlainArgs
import com.pulumi.azurenative.scvmm.kotlin.inputs.GetVirtualNetworkPlainArgsBuilder
import com.pulumi.azurenative.scvmm.kotlin.inputs.GetVmmServerPlainArgs
import com.pulumi.azurenative.scvmm.kotlin.inputs.GetVmmServerPlainArgsBuilder
import com.pulumi.azurenative.scvmm.kotlin.outputs.GetAvailabilitySetResult
import com.pulumi.azurenative.scvmm.kotlin.outputs.GetCloudResult
import com.pulumi.azurenative.scvmm.kotlin.outputs.GetGuestAgentResult
import com.pulumi.azurenative.scvmm.kotlin.outputs.GetHybridIdentityMetadataResult
import com.pulumi.azurenative.scvmm.kotlin.outputs.GetInventoryItemResult
import com.pulumi.azurenative.scvmm.kotlin.outputs.GetMachineExtensionResult
import com.pulumi.azurenative.scvmm.kotlin.outputs.GetVMInstanceGuestAgentResult
import com.pulumi.azurenative.scvmm.kotlin.outputs.GetVirtualMachineInstanceResult
import com.pulumi.azurenative.scvmm.kotlin.outputs.GetVirtualMachineResult
import com.pulumi.azurenative.scvmm.kotlin.outputs.GetVirtualMachineTemplateResult
import com.pulumi.azurenative.scvmm.kotlin.outputs.GetVirtualNetworkResult
import com.pulumi.azurenative.scvmm.kotlin.outputs.GetVmmServerResult
import kotlinx.coroutines.future.await
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import com.pulumi.azurenative.scvmm.kotlin.outputs.GetAvailabilitySetResult.Companion.toKotlin as getAvailabilitySetResultToKotlin
import com.pulumi.azurenative.scvmm.kotlin.outputs.GetCloudResult.Companion.toKotlin as getCloudResultToKotlin
import com.pulumi.azurenative.scvmm.kotlin.outputs.GetGuestAgentResult.Companion.toKotlin as getGuestAgentResultToKotlin
import com.pulumi.azurenative.scvmm.kotlin.outputs.GetHybridIdentityMetadataResult.Companion.toKotlin as getHybridIdentityMetadataResultToKotlin
import com.pulumi.azurenative.scvmm.kotlin.outputs.GetInventoryItemResult.Companion.toKotlin as getInventoryItemResultToKotlin
import com.pulumi.azurenative.scvmm.kotlin.outputs.GetMachineExtensionResult.Companion.toKotlin as getMachineExtensionResultToKotlin
import com.pulumi.azurenative.scvmm.kotlin.outputs.GetVMInstanceGuestAgentResult.Companion.toKotlin as getVMInstanceGuestAgentResultToKotlin
import com.pulumi.azurenative.scvmm.kotlin.outputs.GetVirtualMachineInstanceResult.Companion.toKotlin as getVirtualMachineInstanceResultToKotlin
import com.pulumi.azurenative.scvmm.kotlin.outputs.GetVirtualMachineResult.Companion.toKotlin as getVirtualMachineResultToKotlin
import com.pulumi.azurenative.scvmm.kotlin.outputs.GetVirtualMachineTemplateResult.Companion.toKotlin as getVirtualMachineTemplateResultToKotlin
import com.pulumi.azurenative.scvmm.kotlin.outputs.GetVirtualNetworkResult.Companion.toKotlin as getVirtualNetworkResultToKotlin
import com.pulumi.azurenative.scvmm.kotlin.outputs.GetVmmServerResult.Companion.toKotlin as getVmmServerResultToKotlin

public object ScvmmFunctions {
    /**
     * Implements AvailabilitySet GET method.
     * Azure REST API version: 2022-05-21-preview.
     * Other available API versions: 2023-04-01-preview, 2023-10-07.
     * @param argument null
     * @return The AvailabilitySets resource definition.
     */
    public suspend fun getAvailabilitySet(argument: GetAvailabilitySetPlainArgs): GetAvailabilitySetResult =
        getAvailabilitySetResultToKotlin(getAvailabilitySetPlain(argument.toJava()).await())

    /**
     * @see [getAvailabilitySet].
     * @param availabilitySetName Name of the AvailabilitySet.
     * @param resourceGroupName The name of the resource group.
     * @return The AvailabilitySets resource definition.
     */
    public suspend fun getAvailabilitySet(availabilitySetName: String, resourceGroupName: String): GetAvailabilitySetResult {
        val argument = GetAvailabilitySetPlainArgs(
            availabilitySetName = availabilitySetName,
            resourceGroupName = resourceGroupName,
        )
        return getAvailabilitySetResultToKotlin(getAvailabilitySetPlain(argument.toJava()).await())
    }

    /**
     * @see [getAvailabilitySet].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;scvmm&#46;kotlin&#46;inputs&#46;GetAvailabilitySetPlainArgs].
     * @return The AvailabilitySets resource definition.
     */
    public suspend fun getAvailabilitySet(argument: suspend GetAvailabilitySetPlainArgsBuilder.() -> Unit): GetAvailabilitySetResult {
        val builder = GetAvailabilitySetPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getAvailabilitySetResultToKotlin(getAvailabilitySetPlain(builtArgument.toJava()).await())
    }

    /**
     * Implements Cloud GET method.
     * Azure REST API version: 2022-05-21-preview.
     * Other available API versions: 2023-04-01-preview, 2023-10-07.
     * @param argument null
     * @return The Clouds resource definition.
     */
    public suspend fun getCloud(argument: GetCloudPlainArgs): GetCloudResult =
        getCloudResultToKotlin(getCloudPlain(argument.toJava()).await())

    /**
     * @see [getCloud].
     * @param cloudName Name of the Cloud.
     * @param resourceGroupName The name of the resource group.
     * @return The Clouds resource definition.
     */
    public suspend fun getCloud(cloudName: String, resourceGroupName: String): GetCloudResult {
        val argument = GetCloudPlainArgs(
            cloudName = cloudName,
            resourceGroupName = resourceGroupName,
        )
        return getCloudResultToKotlin(getCloudPlain(argument.toJava()).await())
    }

    /**
     * @see [getCloud].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;scvmm&#46;kotlin&#46;inputs&#46;GetCloudPlainArgs].
     * @return The Clouds resource definition.
     */
    public suspend fun getCloud(argument: suspend GetCloudPlainArgsBuilder.() -> Unit): GetCloudResult {
        val builder = GetCloudPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getCloudResultToKotlin(getCloudPlain(builtArgument.toJava()).await())
    }

    /**
     * Implements GuestAgent GET method.
     * Azure REST API version: 2022-05-21-preview.
     * Other available API versions: 2023-04-01-preview, 2023-10-07.
     * @param argument null
     * @return Defines the GuestAgent.
     */
    public suspend fun getGuestAgent(argument: GetGuestAgentPlainArgs): GetGuestAgentResult =
        getGuestAgentResultToKotlin(getGuestAgentPlain(argument.toJava()).await())

    /**
     * @see [getGuestAgent].
     * @param guestAgentName Name of the GuestAgent.
     * @param resourceGroupName The name of the resource group.
     * @param virtualMachineName Name of the vm.
     * @return Defines the GuestAgent.
     */
    public suspend fun getGuestAgent(
        guestAgentName: String,
        resourceGroupName: String,
        virtualMachineName: String,
    ): GetGuestAgentResult {
        val argument = GetGuestAgentPlainArgs(
            guestAgentName = guestAgentName,
            resourceGroupName = resourceGroupName,
            virtualMachineName = virtualMachineName,
        )
        return getGuestAgentResultToKotlin(getGuestAgentPlain(argument.toJava()).await())
    }

    /**
     * @see [getGuestAgent].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;scvmm&#46;kotlin&#46;inputs&#46;GetGuestAgentPlainArgs].
     * @return Defines the GuestAgent.
     */
    public suspend fun getGuestAgent(argument: suspend GetGuestAgentPlainArgsBuilder.() -> Unit): GetGuestAgentResult {
        val builder = GetGuestAgentPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getGuestAgentResultToKotlin(getGuestAgentPlain(builtArgument.toJava()).await())
    }

    /**
     * Implements HybridIdentityMetadata GET method.
     * Azure REST API version: 2022-05-21-preview.
     * Other available API versions: 2023-04-01-preview.
     * @param argument null
     * @return Defines the HybridIdentityMetadata.
     */
    public suspend fun getHybridIdentityMetadata(argument: GetHybridIdentityMetadataPlainArgs): GetHybridIdentityMetadataResult =
        getHybridIdentityMetadataResultToKotlin(getHybridIdentityMetadataPlain(argument.toJava()).await())

    /**
     * @see [getHybridIdentityMetadata].
     * @param metadataName Name of the HybridIdentityMetadata.
     * @param resourceGroupName The name of the resource group.
     * @param virtualMachineName Name of the vm.
     * @return Defines the HybridIdentityMetadata.
     */
    public suspend fun getHybridIdentityMetadata(
        metadataName: String,
        resourceGroupName: String,
        virtualMachineName: String,
    ): GetHybridIdentityMetadataResult {
        val argument = GetHybridIdentityMetadataPlainArgs(
            metadataName = metadataName,
            resourceGroupName = resourceGroupName,
            virtualMachineName = virtualMachineName,
        )
        return getHybridIdentityMetadataResultToKotlin(getHybridIdentityMetadataPlain(argument.toJava()).await())
    }

    /**
     * @see [getHybridIdentityMetadata].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;scvmm&#46;kotlin&#46;inputs&#46;GetHybridIdentityMetadataPlainArgs].
     * @return Defines the HybridIdentityMetadata.
     */
    public suspend fun getHybridIdentityMetadata(argument: suspend GetHybridIdentityMetadataPlainArgsBuilder.() -> Unit): GetHybridIdentityMetadataResult {
        val builder = GetHybridIdentityMetadataPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getHybridIdentityMetadataResultToKotlin(getHybridIdentityMetadataPlain(builtArgument.toJava()).await())
    }

    /**
     * Shows an inventory item.
     * Azure REST API version: 2022-05-21-preview.
     * Other available API versions: 2023-04-01-preview, 2023-10-07.
     * @param argument null
     * @return Defines the inventory item.
     */
    public suspend fun getInventoryItem(argument: GetInventoryItemPlainArgs): GetInventoryItemResult =
        getInventoryItemResultToKotlin(getInventoryItemPlain(argument.toJava()).await())

    /**
     * @see [getInventoryItem].
     * @param inventoryItemName Name of the inventoryItem.
     * @param resourceGroupName The name of the resource group.
     * @param vmmServerName Name of the VMMServer.
     * @return Defines the inventory item.
     */
    public suspend fun getInventoryItem(
        inventoryItemName: String,
        resourceGroupName: String,
        vmmServerName: String,
    ): GetInventoryItemResult {
        val argument = GetInventoryItemPlainArgs(
            inventoryItemName = inventoryItemName,
            resourceGroupName = resourceGroupName,
            vmmServerName = vmmServerName,
        )
        return getInventoryItemResultToKotlin(getInventoryItemPlain(argument.toJava()).await())
    }

    /**
     * @see [getInventoryItem].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;scvmm&#46;kotlin&#46;inputs&#46;GetInventoryItemPlainArgs].
     * @return Defines the inventory item.
     */
    public suspend fun getInventoryItem(argument: suspend GetInventoryItemPlainArgsBuilder.() -> Unit): GetInventoryItemResult {
        val builder = GetInventoryItemPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getInventoryItemResultToKotlin(getInventoryItemPlain(builtArgument.toJava()).await())
    }

    /**
     * The operation to get the extension.
     * Azure REST API version: 2022-05-21-preview.
     * Other available API versions: 2023-04-01-preview.
     * @param argument null
     * @return Describes a Machine Extension.
     */
    public suspend fun getMachineExtension(argument: GetMachineExtensionPlainArgs): GetMachineExtensionResult =
        getMachineExtensionResultToKotlin(getMachineExtensionPlain(argument.toJava()).await())

    /**
     * @see [getMachineExtension].
     * @param extensionName The name of the machine extension.
     * @param resourceGroupName The name of the resource group.
     * @param virtualMachineName The name of the machine where the extension should be created or updated.
     * @return Describes a Machine Extension.
     */
    public suspend fun getMachineExtension(
        extensionName: String,
        resourceGroupName: String,
        virtualMachineName: String,
    ): GetMachineExtensionResult {
        val argument = GetMachineExtensionPlainArgs(
            extensionName = extensionName,
            resourceGroupName = resourceGroupName,
            virtualMachineName = virtualMachineName,
        )
        return getMachineExtensionResultToKotlin(getMachineExtensionPlain(argument.toJava()).await())
    }

    /**
     * @see [getMachineExtension].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;scvmm&#46;kotlin&#46;inputs&#46;GetMachineExtensionPlainArgs].
     * @return Describes a Machine Extension.
     */
    public suspend fun getMachineExtension(argument: suspend GetMachineExtensionPlainArgsBuilder.() -> Unit): GetMachineExtensionResult {
        val builder = GetMachineExtensionPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getMachineExtensionResultToKotlin(getMachineExtensionPlain(builtArgument.toJava()).await())
    }

    /**
     * Implements GuestAgent GET method.
     * Azure REST API version: 2023-04-01-preview.
     * @param argument null
     * @return Defines the GuestAgent.
     */
    public suspend fun getVMInstanceGuestAgent(argument: GetVMInstanceGuestAgentPlainArgs): GetVMInstanceGuestAgentResult =
        getVMInstanceGuestAgentResultToKotlin(getVMInstanceGuestAgentPlain(argument.toJava()).await())

    /**
     * @see [getVMInstanceGuestAgent].
     * @param resourceUri The fully qualified Azure Resource manager identifier of the Hybrid Compute machine resource to be extended.
     * @return Defines the GuestAgent.
     */
    public suspend fun getVMInstanceGuestAgent(resourceUri: String): GetVMInstanceGuestAgentResult {
        val argument = GetVMInstanceGuestAgentPlainArgs(
            resourceUri = resourceUri,
        )
        return getVMInstanceGuestAgentResultToKotlin(getVMInstanceGuestAgentPlain(argument.toJava()).await())
    }

    /**
     * @see [getVMInstanceGuestAgent].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;scvmm&#46;kotlin&#46;inputs&#46;GetVMInstanceGuestAgentPlainArgs].
     * @return Defines the GuestAgent.
     */
    public suspend fun getVMInstanceGuestAgent(argument: suspend GetVMInstanceGuestAgentPlainArgsBuilder.() -> Unit): GetVMInstanceGuestAgentResult {
        val builder = GetVMInstanceGuestAgentPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getVMInstanceGuestAgentResultToKotlin(getVMInstanceGuestAgentPlain(builtArgument.toJava()).await())
    }

    /**
     * Implements VirtualMachine GET method.
     * Azure REST API version: 2022-05-21-preview.
     * Other available API versions: 2023-04-01-preview.
     * @param argument null
     * @return The VirtualMachines resource definition.
     */
    public suspend fun getVirtualMachine(argument: GetVirtualMachinePlainArgs): GetVirtualMachineResult =
        getVirtualMachineResultToKotlin(getVirtualMachinePlain(argument.toJava()).await())

    /**
     * @see [getVirtualMachine].
     * @param resourceGroupName The name of the resource group.
     * @param virtualMachineName Name of the VirtualMachine.
     * @return The VirtualMachines resource definition.
     */
    public suspend fun getVirtualMachine(resourceGroupName: String, virtualMachineName: String): GetVirtualMachineResult {
        val argument = GetVirtualMachinePlainArgs(
            resourceGroupName = resourceGroupName,
            virtualMachineName = virtualMachineName,
        )
        return getVirtualMachineResultToKotlin(getVirtualMachinePlain(argument.toJava()).await())
    }

    /**
     * @see [getVirtualMachine].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;scvmm&#46;kotlin&#46;inputs&#46;GetVirtualMachinePlainArgs].
     * @return The VirtualMachines resource definition.
     */
    public suspend fun getVirtualMachine(argument: suspend GetVirtualMachinePlainArgsBuilder.() -> Unit): GetVirtualMachineResult {
        val builder = GetVirtualMachinePlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getVirtualMachineResultToKotlin(getVirtualMachinePlain(builtArgument.toJava()).await())
    }

    /**
     * Retrieves information about a virtual machine instance.
     * Azure REST API version: 2023-04-01-preview.
     * Other available API versions: 2023-10-07.
     * @param argument null
     * @return Define the virtualMachineInstance.
     */
    public suspend fun getVirtualMachineInstance(argument: GetVirtualMachineInstancePlainArgs): GetVirtualMachineInstanceResult =
        getVirtualMachineInstanceResultToKotlin(getVirtualMachineInstancePlain(argument.toJava()).await())

    /**
     * @see [getVirtualMachineInstance].
     * @param resourceUri The fully qualified Azure Resource manager identifier of the Hybrid Compute machine resource to be extended.
     * @return Define the virtualMachineInstance.
     */
    public suspend fun getVirtualMachineInstance(resourceUri: String): GetVirtualMachineInstanceResult {
        val argument = GetVirtualMachineInstancePlainArgs(
            resourceUri = resourceUri,
        )
        return getVirtualMachineInstanceResultToKotlin(getVirtualMachineInstancePlain(argument.toJava()).await())
    }

    /**
     * @see [getVirtualMachineInstance].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;scvmm&#46;kotlin&#46;inputs&#46;GetVirtualMachineInstancePlainArgs].
     * @return Define the virtualMachineInstance.
     */
    public suspend fun getVirtualMachineInstance(argument: suspend GetVirtualMachineInstancePlainArgsBuilder.() -> Unit): GetVirtualMachineInstanceResult {
        val builder = GetVirtualMachineInstancePlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getVirtualMachineInstanceResultToKotlin(getVirtualMachineInstancePlain(builtArgument.toJava()).await())
    }

    /**
     * Implements VirtualMachineTemplate GET method.
     * Azure REST API version: 2022-05-21-preview.
     * Other available API versions: 2023-04-01-preview, 2023-10-07.
     * @param argument null
     * @return The VirtualMachineTemplates resource definition.
     */
    public suspend fun getVirtualMachineTemplate(argument: GetVirtualMachineTemplatePlainArgs): GetVirtualMachineTemplateResult =
        getVirtualMachineTemplateResultToKotlin(getVirtualMachineTemplatePlain(argument.toJava()).await())

    /**
     * @see [getVirtualMachineTemplate].
     * @param resourceGroupName The name of the resource group.
     * @param virtualMachineTemplateName Name of the VirtualMachineTemplate.
     * @return The VirtualMachineTemplates resource definition.
     */
    public suspend fun getVirtualMachineTemplate(
        resourceGroupName: String,
        virtualMachineTemplateName: String,
    ): GetVirtualMachineTemplateResult {
        val argument = GetVirtualMachineTemplatePlainArgs(
            resourceGroupName = resourceGroupName,
            virtualMachineTemplateName = virtualMachineTemplateName,
        )
        return getVirtualMachineTemplateResultToKotlin(getVirtualMachineTemplatePlain(argument.toJava()).await())
    }

    /**
     * @see [getVirtualMachineTemplate].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;scvmm&#46;kotlin&#46;inputs&#46;GetVirtualMachineTemplatePlainArgs].
     * @return The VirtualMachineTemplates resource definition.
     */
    public suspend fun getVirtualMachineTemplate(argument: suspend GetVirtualMachineTemplatePlainArgsBuilder.() -> Unit): GetVirtualMachineTemplateResult {
        val builder = GetVirtualMachineTemplatePlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getVirtualMachineTemplateResultToKotlin(getVirtualMachineTemplatePlain(builtArgument.toJava()).await())
    }

    /**
     * Implements VirtualNetwork GET method.
     * Azure REST API version: 2022-05-21-preview.
     * Other available API versions: 2023-04-01-preview, 2023-10-07.
     * @param argument null
     * @return The VirtualNetworks resource definition.
     */
    public suspend fun getVirtualNetwork(argument: GetVirtualNetworkPlainArgs): GetVirtualNetworkResult =
        getVirtualNetworkResultToKotlin(getVirtualNetworkPlain(argument.toJava()).await())

    /**
     * @see [getVirtualNetwork].
     * @param resourceGroupName The name of the resource group.
     * @param virtualNetworkName Name of the VirtualNetwork.
     * @return The VirtualNetworks resource definition.
     */
    public suspend fun getVirtualNetwork(resourceGroupName: String, virtualNetworkName: String): GetVirtualNetworkResult {
        val argument = GetVirtualNetworkPlainArgs(
            resourceGroupName = resourceGroupName,
            virtualNetworkName = virtualNetworkName,
        )
        return getVirtualNetworkResultToKotlin(getVirtualNetworkPlain(argument.toJava()).await())
    }

    /**
     * @see [getVirtualNetwork].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;scvmm&#46;kotlin&#46;inputs&#46;GetVirtualNetworkPlainArgs].
     * @return The VirtualNetworks resource definition.
     */
    public suspend fun getVirtualNetwork(argument: suspend GetVirtualNetworkPlainArgsBuilder.() -> Unit): GetVirtualNetworkResult {
        val builder = GetVirtualNetworkPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getVirtualNetworkResultToKotlin(getVirtualNetworkPlain(builtArgument.toJava()).await())
    }

    /**
     * Implements VMMServer GET method.
     * Azure REST API version: 2022-05-21-preview.
     * Other available API versions: 2023-04-01-preview, 2023-10-07.
     * @param argument null
     * @return The VmmServers resource definition.
     */
    public suspend fun getVmmServer(argument: GetVmmServerPlainArgs): GetVmmServerResult =
        getVmmServerResultToKotlin(getVmmServerPlain(argument.toJava()).await())

    /**
     * @see [getVmmServer].
     * @param resourceGroupName The name of the resource group.
     * @param vmmServerName Name of the VMMServer.
     * @return The VmmServers resource definition.
     */
    public suspend fun getVmmServer(resourceGroupName: String, vmmServerName: String): GetVmmServerResult {
        val argument = GetVmmServerPlainArgs(
            resourceGroupName = resourceGroupName,
            vmmServerName = vmmServerName,
        )
        return getVmmServerResultToKotlin(getVmmServerPlain(argument.toJava()).await())
    }

    /**
     * @see [getVmmServer].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;scvmm&#46;kotlin&#46;inputs&#46;GetVmmServerPlainArgs].
     * @return The VmmServers resource definition.
     */
    public suspend fun getVmmServer(argument: suspend GetVmmServerPlainArgsBuilder.() -> Unit): GetVmmServerResult {
        val builder = GetVmmServerPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getVmmServerResultToKotlin(getVmmServerPlain(builtArgument.toJava()).await())
    }
}
