@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.scvmm.kotlin

import com.pulumi.azurenative.scvmm.kotlin.outputs.GuestCredentialResponse
import com.pulumi.azurenative.scvmm.kotlin.outputs.HttpProxyConfigurationResponse
import com.pulumi.azurenative.scvmm.kotlin.outputs.SystemDataResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import com.pulumi.azurenative.scvmm.kotlin.outputs.GuestCredentialResponse.Companion.toKotlin as guestCredentialResponseToKotlin
import com.pulumi.azurenative.scvmm.kotlin.outputs.HttpProxyConfigurationResponse.Companion.toKotlin as httpProxyConfigurationResponseToKotlin
import com.pulumi.azurenative.scvmm.kotlin.outputs.SystemDataResponse.Companion.toKotlin as systemDataResponseToKotlin

/**
 * Builder for [VMInstanceGuestAgent].
 */
@PulumiTagMarker
public class VMInstanceGuestAgentResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: VMInstanceGuestAgentArgs = VMInstanceGuestAgentArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend VMInstanceGuestAgentArgsBuilder.() -> Unit) {
        val builder = VMInstanceGuestAgentArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): VMInstanceGuestAgent {
        val builtJavaResource =
            com.pulumi.azurenative.scvmm.VMInstanceGuestAgent(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return VMInstanceGuestAgent(builtJavaResource)
    }
}

/**
 * Defines the GuestAgent.
 * Azure REST API version: 2023-04-01-preview.
 * ## Example Usage
 * ### CreateGuestAgent
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var vmInstanceGuestAgent = new AzureNative.ScVmm.VMInstanceGuestAgent("vmInstanceGuestAgent", new()
 *     {
 *         Credentials = new AzureNative.ScVmm.Inputs.GuestCredentialArgs
 *         {
 *             Password = "<password>",
 *             Username = "tempuser",
 *         },
 *         HttpProxyConfig = new AzureNative.ScVmm.Inputs.HttpProxyConfigurationArgs
 *         {
 *             HttpsProxy = "http://192.1.2.3:8080",
 *         },
 *         ProvisioningAction = AzureNative.ScVmm.ProvisioningAction.Install,
 *         ResourceUri = "subscriptions/fd3c3665-1729-4b7b-9a38-238e83b0f98b/resourceGroups/testrg/providers/Microsoft.HybridCompute/machines/DemoVM",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/scvmm/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := scvmm.NewVMInstanceGuestAgent(ctx, "vmInstanceGuestAgent", &scvmm.VMInstanceGuestAgentArgs{
 * 			Credentials: &scvmm.GuestCredentialArgs{
 * 				Password: pulumi.String("<password>"),
 * 				Username: pulumi.String("tempuser"),
 * 			},
 * 			HttpProxyConfig: &scvmm.HttpProxyConfigurationArgs{
 * 				HttpsProxy: pulumi.String("http://192.1.2.3:8080"),
 * 			},
 * 			ProvisioningAction: pulumi.String(scvmm.ProvisioningActionInstall),
 * 			ResourceUri:        pulumi.String("subscriptions/fd3c3665-1729-4b7b-9a38-238e83b0f98b/resourceGroups/testrg/providers/Microsoft.HybridCompute/machines/DemoVM"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.scvmm.VMInstanceGuestAgent;
 * import com.pulumi.azurenative.scvmm.VMInstanceGuestAgentArgs;
 * import com.pulumi.azurenative.scvmm.inputs.GuestCredentialArgs;
 * import com.pulumi.azurenative.scvmm.inputs.HttpProxyConfigurationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var vmInstanceGuestAgent = new VMInstanceGuestAgent("vmInstanceGuestAgent", VMInstanceGuestAgentArgs.builder()
 *             .credentials(GuestCredentialArgs.builder()
 *                 .password("<password>")
 *                 .username("tempuser")
 *                 .build())
 *             .httpProxyConfig(HttpProxyConfigurationArgs.builder()
 *                 .httpsProxy("http://192.1.2.3:8080")
 *                 .build())
 *             .provisioningAction("install")
 *             .resourceUri("subscriptions/fd3c3665-1729-4b7b-9a38-238e83b0f98b/resourceGroups/testrg/providers/Microsoft.HybridCompute/machines/DemoVM")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:scvmm:VMInstanceGuestAgent default /{resourceUri}/providers/Microsoft.ScVmm/virtualMachineInstances/default/guestAgents/default
 * ```
 */
public class VMInstanceGuestAgent internal constructor(
    override val javaResource: com.pulumi.azurenative.scvmm.VMInstanceGuestAgent,
) : KotlinCustomResource(javaResource, VMInstanceGuestAgentMapper) {
    /**
     * Username / Password Credentials to provision guest agent.
     */
    public val credentials: Output<GuestCredentialResponse>?
        get() = javaResource.credentials().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    guestCredentialResponseToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * Gets the name of the corresponding resource in Kubernetes.
     */
    public val customResourceName: Output<String>
        get() = javaResource.customResourceName().applyValue({ args0 -> args0 })

    /**
     * HTTP Proxy configuration for the VM.
     */
    public val httpProxyConfig: Output<HttpProxyConfigurationResponse>?
        get() = javaResource.httpProxyConfig().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> httpProxyConfigurationResponseToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Gets or sets the guest agent provisioning action.
     */
    public val provisioningAction: Output<String>?
        get() = javaResource.provisioningAction().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Gets or sets the provisioning state.
     */
    public val provisioningState: Output<String>
        get() = javaResource.provisioningState().applyValue({ args0 -> args0 })

    /**
     * Gets or sets the guest agent status.
     */
    public val status: Output<String>
        get() = javaResource.status().applyValue({ args0 -> args0 })

    /**
     * Azure Resource Manager metadata containing createdBy and modifiedBy information.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.let({ args0 ->
                systemDataResponseToKotlin(args0)
            })
        })

    /**
     * The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })

    /**
     * Gets or sets a unique identifier for this resource.
     */
    public val uuid: Output<String>
        get() = javaResource.uuid().applyValue({ args0 -> args0 })
}

public object VMInstanceGuestAgentMapper : ResourceMapper<VMInstanceGuestAgent> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.scvmm.VMInstanceGuestAgent::class == javaResource::class

    override fun map(javaResource: Resource): VMInstanceGuestAgent = VMInstanceGuestAgent(
        javaResource
            as com.pulumi.azurenative.scvmm.VMInstanceGuestAgent,
    )
}

/**
 * @see [VMInstanceGuestAgent].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [VMInstanceGuestAgent].
 */
public suspend fun vmInstanceGuestAgent(
    name: String,
    block: suspend VMInstanceGuestAgentResourceBuilder.() -> Unit,
): VMInstanceGuestAgent {
    val builder = VMInstanceGuestAgentResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [VMInstanceGuestAgent].
 * @param name The _unique_ name of the resulting resource.
 */
public fun vmInstanceGuestAgent(name: String): VMInstanceGuestAgent {
    val builder = VMInstanceGuestAgentResourceBuilder()
    builder.name(name)
    return builder.build()
}
