@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.scvmm.kotlin

import com.pulumi.azurenative.scvmm.VirtualMachineArgs.builder
import com.pulumi.azurenative.scvmm.kotlin.inputs.CheckpointArgs
import com.pulumi.azurenative.scvmm.kotlin.inputs.CheckpointArgsBuilder
import com.pulumi.azurenative.scvmm.kotlin.inputs.ExtendedLocationArgs
import com.pulumi.azurenative.scvmm.kotlin.inputs.ExtendedLocationArgsBuilder
import com.pulumi.azurenative.scvmm.kotlin.inputs.GuestAgentProfileArgs
import com.pulumi.azurenative.scvmm.kotlin.inputs.GuestAgentProfileArgsBuilder
import com.pulumi.azurenative.scvmm.kotlin.inputs.HardwareProfileArgs
import com.pulumi.azurenative.scvmm.kotlin.inputs.HardwareProfileArgsBuilder
import com.pulumi.azurenative.scvmm.kotlin.inputs.IdentityArgs
import com.pulumi.azurenative.scvmm.kotlin.inputs.IdentityArgsBuilder
import com.pulumi.azurenative.scvmm.kotlin.inputs.NetworkProfileArgs
import com.pulumi.azurenative.scvmm.kotlin.inputs.NetworkProfileArgsBuilder
import com.pulumi.azurenative.scvmm.kotlin.inputs.OsProfileArgs
import com.pulumi.azurenative.scvmm.kotlin.inputs.OsProfileArgsBuilder
import com.pulumi.azurenative.scvmm.kotlin.inputs.StorageProfileArgs
import com.pulumi.azurenative.scvmm.kotlin.inputs.StorageProfileArgsBuilder
import com.pulumi.azurenative.scvmm.kotlin.inputs.VirtualMachinePropertiesAvailabilitySetsArgs
import com.pulumi.azurenative.scvmm.kotlin.inputs.VirtualMachinePropertiesAvailabilitySetsArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Int
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * The VirtualMachines resource definition.
 * Azure REST API version: 2022-05-21-preview. Prior API version in Azure Native 1.x: 2020-06-05-preview.
 * Other available API versions: 2023-04-01-preview.
 * ## Example Usage
 * ### CreateVirtualMachine
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var virtualMachine = new AzureNative.ScVmm.VirtualMachine("virtualMachine", new()
 *     {
 *         CloudId = "/subscriptions/fd3c3665-1729-4b7b-9a38-238e83b0f98b/resourceGroups/testrg/providers/Microsoft.SCVMM/Clouds/HRCloud",
 *         ExtendedLocation = new AzureNative.ScVmm.Inputs.ExtendedLocationArgs
 *         {
 *             Name = "/subscriptions/a5015e1c-867f-4533-8541-85cd470d0cfb/resourceGroups/demoRG/providers/Microsoft.Arc/customLocations/contoso",
 *             Type = "customLocation",
 *         },
 *         HardwareProfile = new AzureNative.ScVmm.Inputs.HardwareProfileArgs
 *         {
 *             CpuCount = 4,
 *             MemoryMB = 4096,
 *         },
 *         Location = "East US",
 *         ResourceGroupName = "testrg",
 *         TemplateId = "/subscriptions/fd3c3665-1729-4b7b-9a38-238e83b0f98b/resourceGroups/testrg/providers/Microsoft.SCVMM/VirtualMachineTemplates/HRVirtualMachineTemplate",
 *         VirtualMachineName = "DemoVM",
 *         VmmServerId = "/subscriptions/fd3c3665-1729-4b7b-9a38-238e83b0f98b/resourceGroups/testrg/providers/Microsoft.SCVMM/VMMServers/ContosoVMMServer",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/scvmm/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := scvmm.NewVirtualMachine(ctx, "virtualMachine", &scvmm.VirtualMachineArgs{
 * 			CloudId: pulumi.String("/subscriptions/fd3c3665-1729-4b7b-9a38-238e83b0f98b/resourceGroups/testrg/providers/Microsoft.SCVMM/Clouds/HRCloud"),
 * 			ExtendedLocation: &scvmm.ExtendedLocationArgs{
 * 				Name: pulumi.String("/subscriptions/a5015e1c-867f-4533-8541-85cd470d0cfb/resourceGroups/demoRG/providers/Microsoft.Arc/customLocations/contoso"),
 * 				Type: pulumi.String("customLocation"),
 * 			},
 * 			HardwareProfile: &scvmm.HardwareProfileArgs{
 * 				CpuCount: pulumi.Int(4),
 * 				MemoryMB: pulumi.Int(4096),
 * 			},
 * 			Location:           pulumi.String("East US"),
 * 			ResourceGroupName:  pulumi.String("testrg"),
 * 			TemplateId:         pulumi.String("/subscriptions/fd3c3665-1729-4b7b-9a38-238e83b0f98b/resourceGroups/testrg/providers/Microsoft.SCVMM/VirtualMachineTemplates/HRVirtualMachineTemplate"),
 * 			VirtualMachineName: pulumi.String("DemoVM"),
 * 			VmmServerId:        pulumi.String("/subscriptions/fd3c3665-1729-4b7b-9a38-238e83b0f98b/resourceGroups/testrg/providers/Microsoft.SCVMM/VMMServers/ContosoVMMServer"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.scvmm.VirtualMachine;
 * import com.pulumi.azurenative.scvmm.VirtualMachineArgs;
 * import com.pulumi.azurenative.scvmm.inputs.ExtendedLocationArgs;
 * import com.pulumi.azurenative.scvmm.inputs.HardwareProfileArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var virtualMachine = new VirtualMachine("virtualMachine", VirtualMachineArgs.builder()
 *             .cloudId("/subscriptions/fd3c3665-1729-4b7b-9a38-238e83b0f98b/resourceGroups/testrg/providers/Microsoft.SCVMM/Clouds/HRCloud")
 *             .extendedLocation(ExtendedLocationArgs.builder()
 *                 .name("/subscriptions/a5015e1c-867f-4533-8541-85cd470d0cfb/resourceGroups/demoRG/providers/Microsoft.Arc/customLocations/contoso")
 *                 .type("customLocation")
 *                 .build())
 *             .hardwareProfile(HardwareProfileArgs.builder()
 *                 .cpuCount(4)
 *                 .memoryMB(4096)
 *                 .build())
 *             .location("East US")
 *             .resourceGroupName("testrg")
 *             .templateId("/subscriptions/fd3c3665-1729-4b7b-9a38-238e83b0f98b/resourceGroups/testrg/providers/Microsoft.SCVMM/VirtualMachineTemplates/HRVirtualMachineTemplate")
 *             .virtualMachineName("DemoVM")
 *             .vmmServerId("/subscriptions/fd3c3665-1729-4b7b-9a38-238e83b0f98b/resourceGroups/testrg/providers/Microsoft.SCVMM/VMMServers/ContosoVMMServer")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:scvmm:VirtualMachine DemoVM /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ScVmm/virtualMachines/{virtualMachineName}
 * ```
 * @property availabilitySets Availability Sets in vm.
 * @property checkpointType Type of checkpoint supported for the vm.
 * @property checkpoints Checkpoints in the vm.
 * @property cloudId ARM Id of the cloud resource to use for deploying the vm.
 * @property extendedLocation The extended location.
 * @property generation Gets or sets the generation for the vm.
 * @property guestAgentProfile Guest agent status properties.
 * @property hardwareProfile Hardware properties.
 * @property identity The identity of the resource.
 * @property inventoryItemId Gets or sets the inventory Item ID for the resource.
 * @property location Gets or sets the location.
 * @property networkProfile Network properties.
 * @property osProfile OS properties.
 * @property resourceGroupName The name of the resource group.
 * @property storageProfile Storage properties.
 * @property tags Resource tags
 * @property templateId ARM Id of the template resource to use for deploying the vm.
 * @property uuid Unique ID of the virtual machine.
 * @property virtualMachineName Name of the VirtualMachine.
 * @property vmName VMName is the name of VM on the SCVMM server.
 * @property vmmServerId ARM Id of the vmmServer resource in which this resource resides.
 */
public data class VirtualMachineArgs(
    public val availabilitySets: Output<List<VirtualMachinePropertiesAvailabilitySetsArgs>>? = null,
    public val checkpointType: Output<String>? = null,
    public val checkpoints: Output<List<CheckpointArgs>>? = null,
    public val cloudId: Output<String>? = null,
    public val extendedLocation: Output<ExtendedLocationArgs>? = null,
    public val generation: Output<Int>? = null,
    public val guestAgentProfile: Output<GuestAgentProfileArgs>? = null,
    public val hardwareProfile: Output<HardwareProfileArgs>? = null,
    public val identity: Output<IdentityArgs>? = null,
    public val inventoryItemId: Output<String>? = null,
    public val location: Output<String>? = null,
    public val networkProfile: Output<NetworkProfileArgs>? = null,
    public val osProfile: Output<OsProfileArgs>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val storageProfile: Output<StorageProfileArgs>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val templateId: Output<String>? = null,
    public val uuid: Output<String>? = null,
    public val virtualMachineName: Output<String>? = null,
    public val vmName: Output<String>? = null,
    public val vmmServerId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.scvmm.VirtualMachineArgs> {
    override fun toJava(): com.pulumi.azurenative.scvmm.VirtualMachineArgs =
        com.pulumi.azurenative.scvmm.VirtualMachineArgs.builder()
            .availabilitySets(
                availabilitySets?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .checkpointType(checkpointType?.applyValue({ args0 -> args0 }))
            .checkpoints(
                checkpoints?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .cloudId(cloudId?.applyValue({ args0 -> args0 }))
            .extendedLocation(extendedLocation?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .generation(generation?.applyValue({ args0 -> args0 }))
            .guestAgentProfile(guestAgentProfile?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .hardwareProfile(hardwareProfile?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .identity(identity?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .inventoryItemId(inventoryItemId?.applyValue({ args0 -> args0 }))
            .location(location?.applyValue({ args0 -> args0 }))
            .networkProfile(networkProfile?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .osProfile(osProfile?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .storageProfile(storageProfile?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .templateId(templateId?.applyValue({ args0 -> args0 }))
            .uuid(uuid?.applyValue({ args0 -> args0 }))
            .virtualMachineName(virtualMachineName?.applyValue({ args0 -> args0 }))
            .vmName(vmName?.applyValue({ args0 -> args0 }))
            .vmmServerId(vmmServerId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [VirtualMachineArgs].
 */
@PulumiTagMarker
public class VirtualMachineArgsBuilder internal constructor() {
    private var availabilitySets: Output<List<VirtualMachinePropertiesAvailabilitySetsArgs>>? = null

    private var checkpointType: Output<String>? = null

    private var checkpoints: Output<List<CheckpointArgs>>? = null

    private var cloudId: Output<String>? = null

    private var extendedLocation: Output<ExtendedLocationArgs>? = null

    private var generation: Output<Int>? = null

    private var guestAgentProfile: Output<GuestAgentProfileArgs>? = null

    private var hardwareProfile: Output<HardwareProfileArgs>? = null

    private var identity: Output<IdentityArgs>? = null

    private var inventoryItemId: Output<String>? = null

    private var location: Output<String>? = null

    private var networkProfile: Output<NetworkProfileArgs>? = null

    private var osProfile: Output<OsProfileArgs>? = null

    private var resourceGroupName: Output<String>? = null

    private var storageProfile: Output<StorageProfileArgs>? = null

    private var tags: Output<Map<String, String>>? = null

    private var templateId: Output<String>? = null

    private var uuid: Output<String>? = null

    private var virtualMachineName: Output<String>? = null

    private var vmName: Output<String>? = null

    private var vmmServerId: Output<String>? = null

    /**
     * @param value Availability Sets in vm.
     */
    @JvmName("fgysyiueceqrjpmv")
    public suspend fun availabilitySets(`value`: Output<List<VirtualMachinePropertiesAvailabilitySetsArgs>>) {
        this.availabilitySets = value
    }

    @JvmName("teipmyrpwvluetuh")
    public suspend fun availabilitySets(vararg values: Output<VirtualMachinePropertiesAvailabilitySetsArgs>) {
        this.availabilitySets = Output.all(values.asList())
    }

    /**
     * @param values Availability Sets in vm.
     */
    @JvmName("qwtvhbpnjvgsxhch")
    public suspend fun availabilitySets(values: List<Output<VirtualMachinePropertiesAvailabilitySetsArgs>>) {
        this.availabilitySets = Output.all(values)
    }

    /**
     * @param value Type of checkpoint supported for the vm.
     */
    @JvmName("tqnorekgxmuvicpn")
    public suspend fun checkpointType(`value`: Output<String>) {
        this.checkpointType = value
    }

    /**
     * @param value Checkpoints in the vm.
     */
    @JvmName("klabdbaqojsynykn")
    public suspend fun checkpoints(`value`: Output<List<CheckpointArgs>>) {
        this.checkpoints = value
    }

    @JvmName("wjmuyafvfxwsuxen")
    public suspend fun checkpoints(vararg values: Output<CheckpointArgs>) {
        this.checkpoints = Output.all(values.asList())
    }

    /**
     * @param values Checkpoints in the vm.
     */
    @JvmName("orhwmemrjawiybdx")
    public suspend fun checkpoints(values: List<Output<CheckpointArgs>>) {
        this.checkpoints = Output.all(values)
    }

    /**
     * @param value ARM Id of the cloud resource to use for deploying the vm.
     */
    @JvmName("kojlkjnhvfhvvpeq")
    public suspend fun cloudId(`value`: Output<String>) {
        this.cloudId = value
    }

    /**
     * @param value The extended location.
     */
    @JvmName("abqqjmyhmpiixlvt")
    public suspend fun extendedLocation(`value`: Output<ExtendedLocationArgs>) {
        this.extendedLocation = value
    }

    /**
     * @param value Gets or sets the generation for the vm.
     */
    @JvmName("usyborivenapklki")
    public suspend fun generation(`value`: Output<Int>) {
        this.generation = value
    }

    /**
     * @param value Guest agent status properties.
     */
    @JvmName("xqfnojiolhucsvge")
    public suspend fun guestAgentProfile(`value`: Output<GuestAgentProfileArgs>) {
        this.guestAgentProfile = value
    }

    /**
     * @param value Hardware properties.
     */
    @JvmName("xcgysjgktpfrcobg")
    public suspend fun hardwareProfile(`value`: Output<HardwareProfileArgs>) {
        this.hardwareProfile = value
    }

    /**
     * @param value The identity of the resource.
     */
    @JvmName("xdhsoplahymfptel")
    public suspend fun identity(`value`: Output<IdentityArgs>) {
        this.identity = value
    }

    /**
     * @param value Gets or sets the inventory Item ID for the resource.
     */
    @JvmName("bnjrccexrjrwpqdy")
    public suspend fun inventoryItemId(`value`: Output<String>) {
        this.inventoryItemId = value
    }

    /**
     * @param value Gets or sets the location.
     */
    @JvmName("ijrfyuxxoxslkwqj")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value Network properties.
     */
    @JvmName("dmanwenmlbogudbo")
    public suspend fun networkProfile(`value`: Output<NetworkProfileArgs>) {
        this.networkProfile = value
    }

    /**
     * @param value OS properties.
     */
    @JvmName("eaphoucvpbckffky")
    public suspend fun osProfile(`value`: Output<OsProfileArgs>) {
        this.osProfile = value
    }

    /**
     * @param value The name of the resource group.
     */
    @JvmName("soogcfxwiwuqkeal")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Storage properties.
     */
    @JvmName("naoqfkyycwsxsxwa")
    public suspend fun storageProfile(`value`: Output<StorageProfileArgs>) {
        this.storageProfile = value
    }

    /**
     * @param value Resource tags
     */
    @JvmName("gwpbscnipdpambef")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value ARM Id of the template resource to use for deploying the vm.
     */
    @JvmName("akrmhtloijpapuce")
    public suspend fun templateId(`value`: Output<String>) {
        this.templateId = value
    }

    /**
     * @param value Unique ID of the virtual machine.
     */
    @JvmName("hqiulnphloyrqyub")
    public suspend fun uuid(`value`: Output<String>) {
        this.uuid = value
    }

    /**
     * @param value Name of the VirtualMachine.
     */
    @JvmName("rfjimeuwsaslqeqb")
    public suspend fun virtualMachineName(`value`: Output<String>) {
        this.virtualMachineName = value
    }

    /**
     * @param value VMName is the name of VM on the SCVMM server.
     */
    @JvmName("kdybdrixtgnhyvst")
    public suspend fun vmName(`value`: Output<String>) {
        this.vmName = value
    }

    /**
     * @param value ARM Id of the vmmServer resource in which this resource resides.
     */
    @JvmName("uhnounqrbirsbrqx")
    public suspend fun vmmServerId(`value`: Output<String>) {
        this.vmmServerId = value
    }

    /**
     * @param value Availability Sets in vm.
     */
    @JvmName("xqibjmhgbbackmxk")
    public suspend fun availabilitySets(`value`: List<VirtualMachinePropertiesAvailabilitySetsArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.availabilitySets = mapped
    }

    /**
     * @param argument Availability Sets in vm.
     */
    @JvmName("wnwpqhbdchlhnlyf")
    public suspend fun availabilitySets(argument: List<suspend VirtualMachinePropertiesAvailabilitySetsArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            VirtualMachinePropertiesAvailabilitySetsArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.availabilitySets = mapped
    }

    /**
     * @param argument Availability Sets in vm.
     */
    @JvmName("oafvvpsnrpnipyrq")
    public suspend fun availabilitySets(vararg argument: suspend VirtualMachinePropertiesAvailabilitySetsArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            VirtualMachinePropertiesAvailabilitySetsArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.availabilitySets = mapped
    }

    /**
     * @param argument Availability Sets in vm.
     */
    @JvmName("nsjcpdblhfyfwrke")
    public suspend fun availabilitySets(argument: suspend VirtualMachinePropertiesAvailabilitySetsArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            VirtualMachinePropertiesAvailabilitySetsArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.availabilitySets = mapped
    }

    /**
     * @param values Availability Sets in vm.
     */
    @JvmName("vsamfxmhhxjqtnja")
    public suspend fun availabilitySets(vararg values: VirtualMachinePropertiesAvailabilitySetsArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.availabilitySets = mapped
    }

    /**
     * @param value Type of checkpoint supported for the vm.
     */
    @JvmName("hhyurmfgrblmmwtg")
    public suspend fun checkpointType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.checkpointType = mapped
    }

    /**
     * @param value Checkpoints in the vm.
     */
    @JvmName("iyjldhgmqxxurrng")
    public suspend fun checkpoints(`value`: List<CheckpointArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.checkpoints = mapped
    }

    /**
     * @param argument Checkpoints in the vm.
     */
    @JvmName("vqvjaunkaipromia")
    public suspend fun checkpoints(argument: List<suspend CheckpointArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map { CheckpointArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.checkpoints = mapped
    }

    /**
     * @param argument Checkpoints in the vm.
     */
    @JvmName("gnynwdbfkojpvnms")
    public suspend fun checkpoints(vararg argument: suspend CheckpointArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map { CheckpointArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.checkpoints = mapped
    }

    /**
     * @param argument Checkpoints in the vm.
     */
    @JvmName("frdrlwkrjsptxdsi")
    public suspend fun checkpoints(argument: suspend CheckpointArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(CheckpointArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.checkpoints = mapped
    }

    /**
     * @param values Checkpoints in the vm.
     */
    @JvmName("cuvsiymgewlbvcqj")
    public suspend fun checkpoints(vararg values: CheckpointArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.checkpoints = mapped
    }

    /**
     * @param value ARM Id of the cloud resource to use for deploying the vm.
     */
    @JvmName("snsajefhxyevmfra")
    public suspend fun cloudId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.cloudId = mapped
    }

    /**
     * @param value The extended location.
     */
    @JvmName("jbbsxbtodxitakcs")
    public suspend fun extendedLocation(`value`: ExtendedLocationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.extendedLocation = mapped
    }

    /**
     * @param argument The extended location.
     */
    @JvmName("wfsqqjxqiilhajsq")
    public suspend fun extendedLocation(argument: suspend ExtendedLocationArgsBuilder.() -> Unit) {
        val toBeMapped = ExtendedLocationArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.extendedLocation = mapped
    }

    /**
     * @param value Gets or sets the generation for the vm.
     */
    @JvmName("bowkqdvycidruons")
    public suspend fun generation(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.generation = mapped
    }

    /**
     * @param value Guest agent status properties.
     */
    @JvmName("sdrmdtkbiwgfkkdx")
    public suspend fun guestAgentProfile(`value`: GuestAgentProfileArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.guestAgentProfile = mapped
    }

    /**
     * @param argument Guest agent status properties.
     */
    @JvmName("ibvkqylggwmnkwpa")
    public suspend fun guestAgentProfile(argument: suspend GuestAgentProfileArgsBuilder.() -> Unit) {
        val toBeMapped = GuestAgentProfileArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.guestAgentProfile = mapped
    }

    /**
     * @param value Hardware properties.
     */
    @JvmName("ioiocqdkchkobrgw")
    public suspend fun hardwareProfile(`value`: HardwareProfileArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.hardwareProfile = mapped
    }

    /**
     * @param argument Hardware properties.
     */
    @JvmName("fplameedaxfyttqm")
    public suspend fun hardwareProfile(argument: suspend HardwareProfileArgsBuilder.() -> Unit) {
        val toBeMapped = HardwareProfileArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.hardwareProfile = mapped
    }

    /**
     * @param value The identity of the resource.
     */
    @JvmName("ruxcgxmfdypyssoi")
    public suspend fun identity(`value`: IdentityArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.identity = mapped
    }

    /**
     * @param argument The identity of the resource.
     */
    @JvmName("mdwanhygiqyltujv")
    public suspend fun identity(argument: suspend IdentityArgsBuilder.() -> Unit) {
        val toBeMapped = IdentityArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.identity = mapped
    }

    /**
     * @param value Gets or sets the inventory Item ID for the resource.
     */
    @JvmName("chedvdkohlsvhqfj")
    public suspend fun inventoryItemId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.inventoryItemId = mapped
    }

    /**
     * @param value Gets or sets the location.
     */
    @JvmName("sktfsfbdylhfbpvd")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value Network properties.
     */
    @JvmName("wrjvjyokdxfuxcfh")
    public suspend fun networkProfile(`value`: NetworkProfileArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.networkProfile = mapped
    }

    /**
     * @param argument Network properties.
     */
    @JvmName("juogvkkddjeutbds")
    public suspend fun networkProfile(argument: suspend NetworkProfileArgsBuilder.() -> Unit) {
        val toBeMapped = NetworkProfileArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.networkProfile = mapped
    }

    /**
     * @param value OS properties.
     */
    @JvmName("opabtjfsyarieqve")
    public suspend fun osProfile(`value`: OsProfileArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.osProfile = mapped
    }

    /**
     * @param argument OS properties.
     */
    @JvmName("vrkwaajerydfrqgk")
    public suspend fun osProfile(argument: suspend OsProfileArgsBuilder.() -> Unit) {
        val toBeMapped = OsProfileArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.osProfile = mapped
    }

    /**
     * @param value The name of the resource group.
     */
    @JvmName("hdtjtmycyvbhysyj")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Storage properties.
     */
    @JvmName("mdskllpkyenvlqyc")
    public suspend fun storageProfile(`value`: StorageProfileArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.storageProfile = mapped
    }

    /**
     * @param argument Storage properties.
     */
    @JvmName("culbvcsvbqofgmcm")
    public suspend fun storageProfile(argument: suspend StorageProfileArgsBuilder.() -> Unit) {
        val toBeMapped = StorageProfileArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.storageProfile = mapped
    }

    /**
     * @param value Resource tags
     */
    @JvmName("wldusghasqnyahmu")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Resource tags
     */
    @JvmName("vlfxxofyajwxangq")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value ARM Id of the template resource to use for deploying the vm.
     */
    @JvmName("ueesnbpctcudnqui")
    public suspend fun templateId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.templateId = mapped
    }

    /**
     * @param value Unique ID of the virtual machine.
     */
    @JvmName("sytlqgnmyakupnvx")
    public suspend fun uuid(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.uuid = mapped
    }

    /**
     * @param value Name of the VirtualMachine.
     */
    @JvmName("ehhlayanvcxvggfo")
    public suspend fun virtualMachineName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.virtualMachineName = mapped
    }

    /**
     * @param value VMName is the name of VM on the SCVMM server.
     */
    @JvmName("qqghuuejclhxdiqs")
    public suspend fun vmName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vmName = mapped
    }

    /**
     * @param value ARM Id of the vmmServer resource in which this resource resides.
     */
    @JvmName("yycmomehdyvtsthx")
    public suspend fun vmmServerId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vmmServerId = mapped
    }

    internal fun build(): VirtualMachineArgs = VirtualMachineArgs(
        availabilitySets = availabilitySets,
        checkpointType = checkpointType,
        checkpoints = checkpoints,
        cloudId = cloudId,
        extendedLocation = extendedLocation,
        generation = generation,
        guestAgentProfile = guestAgentProfile,
        hardwareProfile = hardwareProfile,
        identity = identity,
        inventoryItemId = inventoryItemId,
        location = location,
        networkProfile = networkProfile,
        osProfile = osProfile,
        resourceGroupName = resourceGroupName,
        storageProfile = storageProfile,
        tags = tags,
        templateId = templateId,
        uuid = uuid,
        virtualMachineName = virtualMachineName,
        vmName = vmName,
        vmmServerId = vmmServerId,
    )
}
