@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.scvmm.kotlin.inputs

import com.pulumi.azurenative.scvmm.inputs.GetVirtualMachineInstancePlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property resourceUri The fully qualified Azure Resource manager identifier of the Hybrid Compute machine resource to be extended.
 */
public data class GetVirtualMachineInstancePlainArgs(
    public val resourceUri: String,
) : ConvertibleToJava<com.pulumi.azurenative.scvmm.inputs.GetVirtualMachineInstancePlainArgs> {
    override fun toJava(): com.pulumi.azurenative.scvmm.inputs.GetVirtualMachineInstancePlainArgs =
        com.pulumi.azurenative.scvmm.inputs.GetVirtualMachineInstancePlainArgs.builder()
            .resourceUri(resourceUri.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetVirtualMachineInstancePlainArgs].
 */
@PulumiTagMarker
public class GetVirtualMachineInstancePlainArgsBuilder internal constructor() {
    private var resourceUri: String? = null

    /**
     * @param value The fully qualified Azure Resource manager identifier of the Hybrid Compute machine resource to be extended.
     */
    @JvmName("mecyyagobggubhqf")
    public suspend fun resourceUri(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceUri = mapped
    }

    internal fun build(): GetVirtualMachineInstancePlainArgs = GetVirtualMachineInstancePlainArgs(
        resourceUri = resourceUri ?: throw PulumiNullFieldException("resourceUri"),
    )
}
