@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.scvmm.kotlin.inputs

import com.pulumi.azurenative.scvmm.inputs.HardwareProfileArgs.builder
import com.pulumi.azurenative.scvmm.kotlin.enums.DynamicMemoryEnabled
import com.pulumi.azurenative.scvmm.kotlin.enums.LimitCpuForMigration
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Defines the resource properties.
 * @property cpuCount Gets or sets the number of vCPUs for the vm.
 * @property dynamicMemoryEnabled Gets or sets a value indicating whether to enable dynamic memory or not.
 * @property dynamicMemoryMaxMB Gets or sets the max dynamic memory for the vm.
 * @property dynamicMemoryMinMB Gets or sets the min dynamic memory for the vm.
 * @property isHighlyAvailable Gets highly available property.
 * @property limitCpuForMigration Gets or sets a value indicating whether to enable processor compatibility mode for live migration of VMs.
 * @property memoryMB MemoryMB is the size of a virtual machine's memory, in MB.
 */
public data class HardwareProfileArgs(
    public val cpuCount: Output<Int>? = null,
    public val dynamicMemoryEnabled: Output<Either<String, DynamicMemoryEnabled>>? = null,
    public val dynamicMemoryMaxMB: Output<Int>? = null,
    public val dynamicMemoryMinMB: Output<Int>? = null,
    public val isHighlyAvailable: Output<String>? = null,
    public val limitCpuForMigration: Output<Either<String, LimitCpuForMigration>>? = null,
    public val memoryMB: Output<Int>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.scvmm.inputs.HardwareProfileArgs> {
    override fun toJava(): com.pulumi.azurenative.scvmm.inputs.HardwareProfileArgs =
        com.pulumi.azurenative.scvmm.inputs.HardwareProfileArgs.builder()
            .cpuCount(cpuCount?.applyValue({ args0 -> args0 }))
            .dynamicMemoryEnabled(
                dynamicMemoryEnabled?.applyValue({ args0 ->
                    args0.transform(
                        { args0 -> args0 },
                        { args0 -> args0.let({ args0 -> args0.toJava() }) },
                    )
                }),
            )
            .dynamicMemoryMaxMB(dynamicMemoryMaxMB?.applyValue({ args0 -> args0 }))
            .dynamicMemoryMinMB(dynamicMemoryMinMB?.applyValue({ args0 -> args0 }))
            .isHighlyAvailable(isHighlyAvailable?.applyValue({ args0 -> args0 }))
            .limitCpuForMigration(
                limitCpuForMigration?.applyValue({ args0 ->
                    args0.transform(
                        { args0 -> args0 },
                        { args0 -> args0.let({ args0 -> args0.toJava() }) },
                    )
                }),
            )
            .memoryMB(memoryMB?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [HardwareProfileArgs].
 */
@PulumiTagMarker
public class HardwareProfileArgsBuilder internal constructor() {
    private var cpuCount: Output<Int>? = null

    private var dynamicMemoryEnabled: Output<Either<String, DynamicMemoryEnabled>>? = null

    private var dynamicMemoryMaxMB: Output<Int>? = null

    private var dynamicMemoryMinMB: Output<Int>? = null

    private var isHighlyAvailable: Output<String>? = null

    private var limitCpuForMigration: Output<Either<String, LimitCpuForMigration>>? = null

    private var memoryMB: Output<Int>? = null

    /**
     * @param value Gets or sets the number of vCPUs for the vm.
     */
    @JvmName("mphvumhxmcygtnjd")
    public suspend fun cpuCount(`value`: Output<Int>) {
        this.cpuCount = value
    }

    /**
     * @param value Gets or sets a value indicating whether to enable dynamic memory or not.
     */
    @JvmName("fccihuyuqmyhjxxu")
    public suspend fun dynamicMemoryEnabled(`value`: Output<Either<String, DynamicMemoryEnabled>>) {
        this.dynamicMemoryEnabled = value
    }

    /**
     * @param value Gets or sets the max dynamic memory for the vm.
     */
    @JvmName("fgvfxluqrnxpewbf")
    public suspend fun dynamicMemoryMaxMB(`value`: Output<Int>) {
        this.dynamicMemoryMaxMB = value
    }

    /**
     * @param value Gets or sets the min dynamic memory for the vm.
     */
    @JvmName("vcqbpvbwudukyblr")
    public suspend fun dynamicMemoryMinMB(`value`: Output<Int>) {
        this.dynamicMemoryMinMB = value
    }

    /**
     * @param value Gets highly available property.
     */
    @JvmName("tbepeatgoalflfch")
    public suspend fun isHighlyAvailable(`value`: Output<String>) {
        this.isHighlyAvailable = value
    }

    /**
     * @param value Gets or sets a value indicating whether to enable processor compatibility mode for live migration of VMs.
     */
    @JvmName("tpsujvediygmjwwc")
    public suspend fun limitCpuForMigration(`value`: Output<Either<String, LimitCpuForMigration>>) {
        this.limitCpuForMigration = value
    }

    /**
     * @param value MemoryMB is the size of a virtual machine's memory, in MB.
     */
    @JvmName("ryrwchcjrsslkbak")
    public suspend fun memoryMB(`value`: Output<Int>) {
        this.memoryMB = value
    }

    /**
     * @param value Gets or sets the number of vCPUs for the vm.
     */
    @JvmName("jhyujuesiwqhevlr")
    public suspend fun cpuCount(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.cpuCount = mapped
    }

    /**
     * @param value Gets or sets a value indicating whether to enable dynamic memory or not.
     */
    @JvmName("mdyvlbmixepcxcjm")
    public suspend fun dynamicMemoryEnabled(`value`: Either<String, DynamicMemoryEnabled>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dynamicMemoryEnabled = mapped
    }

    /**
     * @param value Gets or sets a value indicating whether to enable dynamic memory or not.
     */
    @JvmName("hxvbrffclhhhmxtn")
    public fun dynamicMemoryEnabled(`value`: String) {
        val toBeMapped = Either.ofLeft<String, DynamicMemoryEnabled>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.dynamicMemoryEnabled = mapped
    }

    /**
     * @param value Gets or sets a value indicating whether to enable dynamic memory or not.
     */
    @JvmName("ormqjbiggvqdwrwe")
    public fun dynamicMemoryEnabled(`value`: DynamicMemoryEnabled) {
        val toBeMapped = Either.ofRight<String, DynamicMemoryEnabled>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.dynamicMemoryEnabled = mapped
    }

    /**
     * @param value Gets or sets the max dynamic memory for the vm.
     */
    @JvmName("afykrlimffgdexhg")
    public suspend fun dynamicMemoryMaxMB(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dynamicMemoryMaxMB = mapped
    }

    /**
     * @param value Gets or sets the min dynamic memory for the vm.
     */
    @JvmName("sifvvigkjtkwagxn")
    public suspend fun dynamicMemoryMinMB(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dynamicMemoryMinMB = mapped
    }

    /**
     * @param value Gets highly available property.
     */
    @JvmName("vhpwyriepwtagndj")
    public suspend fun isHighlyAvailable(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.isHighlyAvailable = mapped
    }

    /**
     * @param value Gets or sets a value indicating whether to enable processor compatibility mode for live migration of VMs.
     */
    @JvmName("ywbhscgrurryhkjf")
    public suspend fun limitCpuForMigration(`value`: Either<String, LimitCpuForMigration>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.limitCpuForMigration = mapped
    }

    /**
     * @param value Gets or sets a value indicating whether to enable processor compatibility mode for live migration of VMs.
     */
    @JvmName("qaecfqubjneqbrxf")
    public fun limitCpuForMigration(`value`: String) {
        val toBeMapped = Either.ofLeft<String, LimitCpuForMigration>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.limitCpuForMigration = mapped
    }

    /**
     * @param value Gets or sets a value indicating whether to enable processor compatibility mode for live migration of VMs.
     */
    @JvmName("bqdvmskvgdxfiqpd")
    public fun limitCpuForMigration(`value`: LimitCpuForMigration) {
        val toBeMapped = Either.ofRight<String, LimitCpuForMigration>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.limitCpuForMigration = mapped
    }

    /**
     * @param value MemoryMB is the size of a virtual machine's memory, in MB.
     */
    @JvmName("dhcrmnvpomgynuhd")
    public suspend fun memoryMB(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.memoryMB = mapped
    }

    internal fun build(): HardwareProfileArgs = HardwareProfileArgs(
        cpuCount = cpuCount,
        dynamicMemoryEnabled = dynamicMemoryEnabled,
        dynamicMemoryMaxMB = dynamicMemoryMaxMB,
        dynamicMemoryMinMB = dynamicMemoryMinMB,
        isHighlyAvailable = isHighlyAvailable,
        limitCpuForMigration = limitCpuForMigration,
        memoryMB = memoryMB,
    )
}
