@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.scvmm.kotlin.inputs

import com.pulumi.azurenative.scvmm.inputs.VMMServerPropertiesCredentialsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Credentials to connect to VMMServer.
 * @property password Credentials to use to connect to VMMServer.
 * @property username Username to use to connect to VMMServer.
 */
public data class VMMServerPropertiesCredentialsArgs(
    public val password: Output<String>? = null,
    public val username: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.scvmm.inputs.VMMServerPropertiesCredentialsArgs> {
    override fun toJava(): com.pulumi.azurenative.scvmm.inputs.VMMServerPropertiesCredentialsArgs =
        com.pulumi.azurenative.scvmm.inputs.VMMServerPropertiesCredentialsArgs.builder()
            .password(password?.applyValue({ args0 -> args0 }))
            .username(username?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [VMMServerPropertiesCredentialsArgs].
 */
@PulumiTagMarker
public class VMMServerPropertiesCredentialsArgsBuilder internal constructor() {
    private var password: Output<String>? = null

    private var username: Output<String>? = null

    /**
     * @param value Credentials to use to connect to VMMServer.
     */
    @JvmName("pcrsxihyrdcojcvr")
    public suspend fun password(`value`: Output<String>) {
        this.password = value
    }

    /**
     * @param value Username to use to connect to VMMServer.
     */
    @JvmName("awlrxtldpxaktfxp")
    public suspend fun username(`value`: Output<String>) {
        this.username = value
    }

    /**
     * @param value Credentials to use to connect to VMMServer.
     */
    @JvmName("kxkawmjqyglpthua")
    public suspend fun password(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.password = mapped
    }

    /**
     * @param value Username to use to connect to VMMServer.
     */
    @JvmName("hmxiqjksvhgwoupt")
    public suspend fun username(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.username = mapped
    }

    internal fun build(): VMMServerPropertiesCredentialsArgs = VMMServerPropertiesCredentialsArgs(
        password = password,
        username = username,
    )
}
