@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.scvmm.kotlin.outputs

import kotlin.Double
import kotlin.Suppress

/**
 * Cloud Capacity model
 * @property cpuCount CPUCount specifies the maximum number of CPUs that can be allocated in the cloud.
 * @property memoryMB MemoryMB specifies a memory usage limit in megabytes.
 * @property vmCount VMCount gives the max number of VMs that can be deployed in the cloud.
 */
public data class CloudCapacityResponse(
    public val cpuCount: Double? = null,
    public val memoryMB: Double? = null,
    public val vmCount: Double? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.scvmm.outputs.CloudCapacityResponse): CloudCapacityResponse = CloudCapacityResponse(
            cpuCount = javaType.cpuCount().map({ args0 -> args0 }).orElse(null),
            memoryMB = javaType.memoryMB().map({ args0 -> args0 }).orElse(null),
            vmCount = javaType.vmCount().map({ args0 -> args0 }).orElse(null),
        )
    }
}
