@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.scvmm.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map

/**
 * The AvailabilitySets resource definition.
 * @property availabilitySetName Name of the availability set.
 * @property extendedLocation The extended location.
 * @property id Resource Id
 * @property location Gets or sets the location.
 * @property name Resource Name
 * @property provisioningState Gets or sets the provisioning state.
 * @property systemData The system data.
 * @property tags Resource tags
 * @property type Resource Type
 * @property vmmServerId ARM Id of the vmmServer resource in which this resource resides.
 */
public data class GetAvailabilitySetResult(
    public val availabilitySetName: String? = null,
    public val extendedLocation: ExtendedLocationResponse? = null,
    public val id: String,
    public val location: String? = null,
    public val name: String,
    public val provisioningState: String,
    public val systemData: SystemDataResponse,
    public val tags: Map<String, String>? = null,
    public val type: String,
    public val vmmServerId: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.scvmm.outputs.GetAvailabilitySetResult): GetAvailabilitySetResult = GetAvailabilitySetResult(
            availabilitySetName = javaType.availabilitySetName().map({ args0 -> args0 }).orElse(null),
            extendedLocation = javaType.extendedLocation().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.scvmm.kotlin.outputs.ExtendedLocationResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            id = javaType.id(),
            location = javaType.location().map({ args0 -> args0 }).orElse(null),
            name = javaType.name(),
            provisioningState = javaType.provisioningState(),
            systemData = javaType.systemData().let({ args0 ->
                com.pulumi.azurenative.scvmm.kotlin.outputs.SystemDataResponse.Companion.toKotlin(args0)
            }),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            type = javaType.type(),
            vmmServerId = javaType.vmmServerId().map({ args0 -> args0 }).orElse(null),
        )
    }
}
