@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.scvmm.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 * The Clouds resource definition.
 * @property cloudCapacity Capacity of the cloud.
 * @property cloudName Name of the cloud in VMMServer.
 * @property extendedLocation The extended location.
 * @property id Resource Id
 * @property inventoryItemId Gets or sets the inventory Item ID for the resource.
 * @property location Gets or sets the location.
 * @property name Resource Name
 * @property provisioningState Gets or sets the provisioning state.
 * @property storageQoSPolicies List of QoS policies available for the cloud.
 * @property systemData The system data.
 * @property tags Resource tags
 * @property type Resource Type
 * @property uuid Unique ID of the cloud.
 * @property vmmServerId ARM Id of the vmmServer resource in which this resource resides.
 */
public data class GetCloudResult(
    public val cloudCapacity: CloudCapacityResponse,
    public val cloudName: String,
    public val extendedLocation: ExtendedLocationResponse,
    public val id: String,
    public val inventoryItemId: String? = null,
    public val location: String,
    public val name: String,
    public val provisioningState: String,
    public val storageQoSPolicies: List<StorageQoSPolicyResponse>,
    public val systemData: SystemDataResponse,
    public val tags: Map<String, String>? = null,
    public val type: String,
    public val uuid: String? = null,
    public val vmmServerId: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.scvmm.outputs.GetCloudResult): GetCloudResult = GetCloudResult(
            cloudCapacity = javaType.cloudCapacity().let({ args0 ->
                com.pulumi.azurenative.scvmm.kotlin.outputs.CloudCapacityResponse.Companion.toKotlin(args0)
            }),
            cloudName = javaType.cloudName(),
            extendedLocation = javaType.extendedLocation().let({ args0 ->
                com.pulumi.azurenative.scvmm.kotlin.outputs.ExtendedLocationResponse.Companion.toKotlin(args0)
            }),
            id = javaType.id(),
            inventoryItemId = javaType.inventoryItemId().map({ args0 -> args0 }).orElse(null),
            location = javaType.location(),
            name = javaType.name(),
            provisioningState = javaType.provisioningState(),
            storageQoSPolicies = javaType.storageQoSPolicies().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.scvmm.kotlin.outputs.StorageQoSPolicyResponse.Companion.toKotlin(args0)
                })
            }),
            systemData = javaType.systemData().let({ args0 ->
                com.pulumi.azurenative.scvmm.kotlin.outputs.SystemDataResponse.Companion.toKotlin(args0)
            }),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            type = javaType.type(),
            uuid = javaType.uuid().map({ args0 -> args0 }).orElse(null),
            vmmServerId = javaType.vmmServerId().map({ args0 -> args0 }).orElse(null),
        )
    }
}
