@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.scvmm.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Defines the HybridIdentityMetadata.
 * @property id Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
 * @property identity The identity of the resource.
 * @property name The name of the resource
 * @property provisioningState Gets or sets the provisioning state.
 * @property publicKey Gets or sets the Public Key.
 * @property resourceUid Gets or sets the Vm Id.
 * @property systemData Azure Resource Manager metadata containing createdBy and modifiedBy information.
 * @property type The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
 */
public data class GetHybridIdentityMetadataResult(
    public val id: String,
    public val identity: IdentityResponse,
    public val name: String,
    public val provisioningState: String,
    public val publicKey: String? = null,
    public val resourceUid: String? = null,
    public val systemData: SystemDataResponse,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.scvmm.outputs.GetHybridIdentityMetadataResult): GetHybridIdentityMetadataResult = GetHybridIdentityMetadataResult(
            id = javaType.id(),
            identity = javaType.identity().let({ args0 ->
                com.pulumi.azurenative.scvmm.kotlin.outputs.IdentityResponse.Companion.toKotlin(args0)
            }),
            name = javaType.name(),
            provisioningState = javaType.provisioningState(),
            publicKey = javaType.publicKey().map({ args0 -> args0 }).orElse(null),
            resourceUid = javaType.resourceUid().map({ args0 -> args0 }).orElse(null),
            systemData = javaType.systemData().let({ args0 ->
                com.pulumi.azurenative.scvmm.kotlin.outputs.SystemDataResponse.Companion.toKotlin(args0)
            }),
            type = javaType.type(),
        )
    }
}
