@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.scvmm.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Defines the inventory item.
 * @property id Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
 * @property inventoryItemName Gets the Managed Object name in VMM for the inventory item.
 * @property inventoryType They inventory type.
 * @property kind Metadata used by portal/tooling/etc to render different UX experiences for resources of the same type; e.g. ApiApps are a kind of Microsoft.Web/sites type.  If supported, the resource provider must validate and persist this value.
 * @property managedResourceId Gets the tracked resource id corresponding to the inventory resource.
 * @property name The name of the resource
 * @property provisioningState Gets the provisioning state.
 * @property systemData Azure Resource Manager metadata containing createdBy and modifiedBy information.
 * @property type The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
 * @property uuid Gets the UUID (which is assigned by VMM) for the inventory item.
 */
public data class GetInventoryItemResult(
    public val id: String,
    public val inventoryItemName: String,
    public val inventoryType: String,
    public val kind: String? = null,
    public val managedResourceId: String,
    public val name: String,
    public val provisioningState: String,
    public val systemData: SystemDataResponse,
    public val type: String,
    public val uuid: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.scvmm.outputs.GetInventoryItemResult): GetInventoryItemResult = GetInventoryItemResult(
            id = javaType.id(),
            inventoryItemName = javaType.inventoryItemName(),
            inventoryType = javaType.inventoryType(),
            kind = javaType.kind().map({ args0 -> args0 }).orElse(null),
            managedResourceId = javaType.managedResourceId(),
            name = javaType.name(),
            provisioningState = javaType.provisioningState(),
            systemData = javaType.systemData().let({ args0 ->
                com.pulumi.azurenative.scvmm.kotlin.outputs.SystemDataResponse.Companion.toKotlin(args0)
            }),
            type = javaType.type(),
            uuid = javaType.uuid(),
        )
    }
}
