@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.scvmm.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 * The VirtualMachineTemplates resource definition.
 * @property computerName Gets or sets computer name.
 * @property cpuCount Gets or sets the desired number of vCPUs for the vm.
 * @property disks Gets or sets the disks of the template.
 * @property dynamicMemoryEnabled Gets or sets a value indicating whether to enable dynamic memory or not.
 * @property dynamicMemoryMaxMB Gets or sets the max dynamic memory for the vm.
 * @property dynamicMemoryMinMB Gets or sets the min dynamic memory for the vm.
 * @property extendedLocation The extended location.
 * @property generation Gets or sets the generation for the vm.
 * @property id Resource Id
 * @property inventoryItemId Gets or sets the inventory Item ID for the resource.
 * @property isCustomizable Gets or sets a value indicating whether the vm template is customizable or not.
 * @property isHighlyAvailable Gets highly available property.
 * @property limitCpuForMigration Gets or sets a value indicating whether to enable processor compatibility mode for live migration of VMs.
 * @property location Gets or sets the location.
 * @property memoryMB MemoryMB is the desired size of a virtual machine's memory, in MB.
 * @property name Resource Name
 * @property networkInterfaces Gets or sets the network interfaces of the template.
 * @property osName Gets or sets os name.
 * @property osType Gets or sets the type of the os.
 * @property provisioningState Gets or sets the provisioning state.
 * @property systemData The system data.
 * @property tags Resource tags
 * @property type Resource Type
 * @property uuid Unique ID of the virtual machine template.
 * @property vmmServerId ARM Id of the vmmServer resource in which this resource resides.
 */
public data class GetVirtualMachineTemplateResult(
    public val computerName: String,
    public val cpuCount: Int,
    public val disks: List<VirtualDiskResponse>,
    public val dynamicMemoryEnabled: String,
    public val dynamicMemoryMaxMB: Int,
    public val dynamicMemoryMinMB: Int,
    public val extendedLocation: ExtendedLocationResponse,
    public val generation: Int,
    public val id: String,
    public val inventoryItemId: String? = null,
    public val isCustomizable: String,
    public val isHighlyAvailable: String,
    public val limitCpuForMigration: String,
    public val location: String,
    public val memoryMB: Int,
    public val name: String,
    public val networkInterfaces: List<NetworkInterfacesResponse>,
    public val osName: String,
    public val osType: String,
    public val provisioningState: String,
    public val systemData: SystemDataResponse,
    public val tags: Map<String, String>? = null,
    public val type: String,
    public val uuid: String? = null,
    public val vmmServerId: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.scvmm.outputs.GetVirtualMachineTemplateResult): GetVirtualMachineTemplateResult = GetVirtualMachineTemplateResult(
            computerName = javaType.computerName(),
            cpuCount = javaType.cpuCount(),
            disks = javaType.disks().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.scvmm.kotlin.outputs.VirtualDiskResponse.Companion.toKotlin(args0)
                })
            }),
            dynamicMemoryEnabled = javaType.dynamicMemoryEnabled(),
            dynamicMemoryMaxMB = javaType.dynamicMemoryMaxMB(),
            dynamicMemoryMinMB = javaType.dynamicMemoryMinMB(),
            extendedLocation = javaType.extendedLocation().let({ args0 ->
                com.pulumi.azurenative.scvmm.kotlin.outputs.ExtendedLocationResponse.Companion.toKotlin(args0)
            }),
            generation = javaType.generation(),
            id = javaType.id(),
            inventoryItemId = javaType.inventoryItemId().map({ args0 -> args0 }).orElse(null),
            isCustomizable = javaType.isCustomizable(),
            isHighlyAvailable = javaType.isHighlyAvailable(),
            limitCpuForMigration = javaType.limitCpuForMigration(),
            location = javaType.location(),
            memoryMB = javaType.memoryMB(),
            name = javaType.name(),
            networkInterfaces = javaType.networkInterfaces().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.scvmm.kotlin.outputs.NetworkInterfacesResponse.Companion.toKotlin(args0)
                })
            }),
            osName = javaType.osName(),
            osType = javaType.osType(),
            provisioningState = javaType.provisioningState(),
            systemData = javaType.systemData().let({ args0 ->
                com.pulumi.azurenative.scvmm.kotlin.outputs.SystemDataResponse.Companion.toKotlin(args0)
            }),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            type = javaType.type(),
            uuid = javaType.uuid().map({ args0 -> args0 }).orElse(null),
            vmmServerId = javaType.vmmServerId().map({ args0 -> args0 }).orElse(null),
        )
    }
}
