@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.scvmm.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map

/**
 * The VirtualNetworks resource definition.
 * @property extendedLocation The extended location.
 * @property id Resource Id
 * @property inventoryItemId Gets or sets the inventory Item ID for the resource.
 * @property location Gets or sets the location.
 * @property name Resource Name
 * @property networkName Name of the virtual network in vmmServer.
 * @property provisioningState Gets or sets the provisioning state.
 * @property systemData The system data.
 * @property tags Resource tags
 * @property type Resource Type
 * @property uuid Unique ID of the virtual network.
 * @property vmmServerId ARM Id of the vmmServer resource in which this resource resides.
 */
public data class GetVirtualNetworkResult(
    public val extendedLocation: ExtendedLocationResponse,
    public val id: String,
    public val inventoryItemId: String? = null,
    public val location: String,
    public val name: String,
    public val networkName: String,
    public val provisioningState: String,
    public val systemData: SystemDataResponse,
    public val tags: Map<String, String>? = null,
    public val type: String,
    public val uuid: String? = null,
    public val vmmServerId: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.scvmm.outputs.GetVirtualNetworkResult): GetVirtualNetworkResult = GetVirtualNetworkResult(
            extendedLocation = javaType.extendedLocation().let({ args0 ->
                com.pulumi.azurenative.scvmm.kotlin.outputs.ExtendedLocationResponse.Companion.toKotlin(args0)
            }),
            id = javaType.id(),
            inventoryItemId = javaType.inventoryItemId().map({ args0 -> args0 }).orElse(null),
            location = javaType.location(),
            name = javaType.name(),
            networkName = javaType.networkName(),
            provisioningState = javaType.provisioningState(),
            systemData = javaType.systemData().let({ args0 ->
                com.pulumi.azurenative.scvmm.kotlin.outputs.SystemDataResponse.Companion.toKotlin(args0)
            }),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            type = javaType.type(),
            uuid = javaType.uuid().map({ args0 -> args0 }).orElse(null),
            vmmServerId = javaType.vmmServerId().map({ args0 -> args0 }).orElse(null),
        )
    }
}
