@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.scvmm.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map

/**
 * The VmmServers resource definition.
 * @property connectionStatus Gets or sets the connection status to the vmmServer.
 * @property credentials Credentials to connect to VMMServer.
 * @property errorMessage Gets or sets any error message if connection to vmmServer is having any issue.
 * @property extendedLocation The extended location.
 * @property fqdn Fqdn is the hostname/ip of the vmmServer.
 * @property id Resource Id
 * @property location Gets or sets the location.
 * @property name Resource Name
 * @property port Port is the port on which the vmmServer is listening.
 * @property provisioningState Gets or sets the provisioning state.
 * @property systemData The system data.
 * @property tags Resource tags
 * @property type Resource Type
 * @property uuid Unique ID of vmmServer.
 * @property version Version is the version of the vmmSever.
 */
public data class GetVmmServerResult(
    public val connectionStatus: String,
    public val credentials: VMMServerPropertiesResponseCredentials? = null,
    public val errorMessage: String,
    public val extendedLocation: ExtendedLocationResponse,
    public val fqdn: String,
    public val id: String,
    public val location: String,
    public val name: String,
    public val port: Int? = null,
    public val provisioningState: String,
    public val systemData: SystemDataResponse,
    public val tags: Map<String, String>? = null,
    public val type: String,
    public val uuid: String,
    public val version: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.scvmm.outputs.GetVmmServerResult): GetVmmServerResult = GetVmmServerResult(
            connectionStatus = javaType.connectionStatus(),
            credentials = javaType.credentials().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.scvmm.kotlin.outputs.VMMServerPropertiesResponseCredentials.Companion.toKotlin(args0)
                })
            }).orElse(null),
            errorMessage = javaType.errorMessage(),
            extendedLocation = javaType.extendedLocation().let({ args0 ->
                com.pulumi.azurenative.scvmm.kotlin.outputs.ExtendedLocationResponse.Companion.toKotlin(args0)
            }),
            fqdn = javaType.fqdn(),
            id = javaType.id(),
            location = javaType.location(),
            name = javaType.name(),
            port = javaType.port().map({ args0 -> args0 }).orElse(null),
            provisioningState = javaType.provisioningState(),
            systemData = javaType.systemData().let({ args0 ->
                com.pulumi.azurenative.scvmm.kotlin.outputs.SystemDataResponse.Companion.toKotlin(args0)
            }),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            type = javaType.type(),
            uuid = javaType.uuid(),
            version = javaType.version(),
        )
    }
}
