@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.scvmm.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 * Defines the resource properties.
 * @property cpuCount Gets or sets the number of vCPUs for the vm.
 * @property dynamicMemoryEnabled Gets or sets a value indicating whether to enable dynamic memory or not.
 * @property dynamicMemoryMaxMB Gets or sets the max dynamic memory for the vm.
 * @property dynamicMemoryMinMB Gets or sets the min dynamic memory for the vm.
 * @property isHighlyAvailable Gets highly available property.
 * @property limitCpuForMigration Gets or sets a value indicating whether to enable processor compatibility mode for live migration of VMs.
 * @property memoryMB MemoryMB is the size of a virtual machine's memory, in MB.
 */
public data class HardwareProfileResponse(
    public val cpuCount: Int? = null,
    public val dynamicMemoryEnabled: String? = null,
    public val dynamicMemoryMaxMB: Int? = null,
    public val dynamicMemoryMinMB: Int? = null,
    public val isHighlyAvailable: String? = null,
    public val limitCpuForMigration: String? = null,
    public val memoryMB: Int? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.scvmm.outputs.HardwareProfileResponse): HardwareProfileResponse = HardwareProfileResponse(
            cpuCount = javaType.cpuCount().map({ args0 -> args0 }).orElse(null),
            dynamicMemoryEnabled = javaType.dynamicMemoryEnabled().map({ args0 -> args0 }).orElse(null),
            dynamicMemoryMaxMB = javaType.dynamicMemoryMaxMB().map({ args0 -> args0 }).orElse(null),
            dynamicMemoryMinMB = javaType.dynamicMemoryMinMB().map({ args0 -> args0 }).orElse(null),
            isHighlyAvailable = javaType.isHighlyAvailable().map({ args0 -> args0 }).orElse(null),
            limitCpuForMigration = javaType.limitCpuForMigration().map({ args0 -> args0 }).orElse(null),
            memoryMB = javaType.memoryMB().map({ args0 -> args0 }).orElse(null),
        )
    }
}
