@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.scvmm.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Defines the resource properties.
 * @property computerName Gets or sets computer name.
 * @property osSku Gets or sets os sku.
 * @property osType Gets or sets the type of the os.
 * @property osVersion Gets os version.
 */
public data class OsProfileForVMInstanceResponse(
    public val computerName: String? = null,
    public val osSku: String,
    public val osType: String,
    public val osVersion: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.scvmm.outputs.OsProfileForVMInstanceResponse): OsProfileForVMInstanceResponse = OsProfileForVMInstanceResponse(
            computerName = javaType.computerName().map({ args0 -> args0 }).orElse(null),
            osSku = javaType.osSku(),
            osType = javaType.osType(),
            osVersion = javaType.osVersion(),
        )
    }
}
