@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.scvmm.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Defines the resource properties.
 * @property computerName Gets or sets computer name.
 * @property osName Gets or sets os name.
 * @property osType Gets or sets the type of the os.
 */
public data class OsProfileResponse(
    public val computerName: String? = null,
    public val osName: String,
    public val osType: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.scvmm.outputs.OsProfileResponse): OsProfileResponse = OsProfileResponse(
            computerName = javaType.computerName().map({ args0 -> args0 }).orElse(null),
            osName = javaType.osName(),
            osType = javaType.osType(),
        )
    }
}
