@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.scvmm.kotlin.outputs

import kotlin.Double
import kotlin.String
import kotlin.Suppress

/**
 * The StorageQoSPolicy definition.
 * @property bandwidthLimit The Bandwidth Limit for internet traffic.
 * @property id The ID of the QoS policy.
 * @property iopsMaximum The maximum IO operations per second.
 * @property iopsMinimum The minimum IO operations per second.
 * @property name The name of the policy.
 * @property policyId The underlying policy.
 */
public data class StorageQoSPolicyResponse(
    public val bandwidthLimit: Double? = null,
    public val id: String? = null,
    public val iopsMaximum: Double? = null,
    public val iopsMinimum: Double? = null,
    public val name: String? = null,
    public val policyId: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.scvmm.outputs.StorageQoSPolicyResponse): StorageQoSPolicyResponse = StorageQoSPolicyResponse(
            bandwidthLimit = javaType.bandwidthLimit().map({ args0 -> args0 }).orElse(null),
            id = javaType.id().map({ args0 -> args0 }).orElse(null),
            iopsMaximum = javaType.iopsMaximum().map({ args0 -> args0 }).orElse(null),
            iopsMinimum = javaType.iopsMinimum().map({ args0 -> args0 }).orElse(null),
            name = javaType.name().map({ args0 -> args0 }).orElse(null),
            policyId = javaType.policyId().map({ args0 -> args0 }).orElse(null),
        )
    }
}
