@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.search.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * The provisioning state of the private link service connection. Can be Updating, Deleting, Failed, Succeeded, or Incomplete
 */
public enum class PrivateLinkServiceConnectionProvisioningState(
    public val javaValue: com.pulumi.azurenative.search.enums.PrivateLinkServiceConnectionProvisioningState,
) :
    ConvertibleToJava<com.pulumi.azurenative.search.enums.PrivateLinkServiceConnectionProvisioningState> {
    /**
     * The private link service connection is in the process of being created along with other resources for it to be fully functional.
     */
    Updating(com.pulumi.azurenative.search.enums.PrivateLinkServiceConnectionProvisioningState.Updating),

    /**
     * The private link service connection is in the process of being deleted.
     */
    Deleting(com.pulumi.azurenative.search.enums.PrivateLinkServiceConnectionProvisioningState.Deleting),

    /**
     * The private link service connection has failed to be provisioned or deleted.
     */
    Failed(com.pulumi.azurenative.search.enums.PrivateLinkServiceConnectionProvisioningState.Failed),

    /**
     * The private link service connection has finished provisioning and is ready for approval.
     */
    Succeeded(com.pulumi.azurenative.search.enums.PrivateLinkServiceConnectionProvisioningState.Succeeded),

    /**
     * Provisioning request for the private link service connection resource has been accepted but the process of creation has not commenced yet.
     */
    Incomplete(com.pulumi.azurenative.search.enums.PrivateLinkServiceConnectionProvisioningState.Incomplete),

    /**
     * Provisioning request for the private link service connection resource has been canceled
     */
    Canceled(com.pulumi.azurenative.search.enums.PrivateLinkServiceConnectionProvisioningState.Canceled),
    ;

    override fun toJava(): com.pulumi.azurenative.search.enums.PrivateLinkServiceConnectionProvisioningState = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.search.enums.PrivateLinkServiceConnectionProvisioningState): PrivateLinkServiceConnectionProvisioningState =
            PrivateLinkServiceConnectionProvisioningState.values().first { it.javaValue == javaType }
    }
}
