@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.search.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * Status of the shared private link resource. Can be Pending, Approved, Rejected or Disconnected.
 */
public enum class SharedPrivateLinkResourceStatus(
    public val javaValue: com.pulumi.azurenative.search.enums.SharedPrivateLinkResourceStatus,
) : ConvertibleToJava<com.pulumi.azurenative.search.enums.SharedPrivateLinkResourceStatus> {
    Pending(com.pulumi.azurenative.search.enums.SharedPrivateLinkResourceStatus.Pending),
    Approved(com.pulumi.azurenative.search.enums.SharedPrivateLinkResourceStatus.Approved),
    Rejected(com.pulumi.azurenative.search.enums.SharedPrivateLinkResourceStatus.Rejected),
    Disconnected(com.pulumi.azurenative.search.enums.SharedPrivateLinkResourceStatus.Disconnected),
    ;

    override fun toJava(): com.pulumi.azurenative.search.enums.SharedPrivateLinkResourceStatus =
        javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.search.enums.SharedPrivateLinkResourceStatus): SharedPrivateLinkResourceStatus =
            SharedPrivateLinkResourceStatus.values().first { it.javaValue == javaType }
    }
}
