@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.search.kotlin.inputs

import com.pulumi.azurenative.search.inputs.DataPlaneAuthOptionsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Any
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Defines the options for how the data plane API of a Search service authenticates requests. This cannot be set if 'disableLocalAuth' is set to true.
 * @property aadOrApiKey Indicates that either the API key or an access token from Azure Active Directory can be used for authentication.
 * @property apiKeyOnly Indicates that only the API key needs to be used for authentication.
 */
public data class DataPlaneAuthOptionsArgs(
    public val aadOrApiKey: Output<DataPlaneAadOrApiKeyAuthOptionArgs>? = null,
    public val apiKeyOnly: Output<Any>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.search.inputs.DataPlaneAuthOptionsArgs> {
    override fun toJava(): com.pulumi.azurenative.search.inputs.DataPlaneAuthOptionsArgs =
        com.pulumi.azurenative.search.inputs.DataPlaneAuthOptionsArgs.builder()
            .aadOrApiKey(aadOrApiKey?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .apiKeyOnly(apiKeyOnly?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [DataPlaneAuthOptionsArgs].
 */
@PulumiTagMarker
public class DataPlaneAuthOptionsArgsBuilder internal constructor() {
    private var aadOrApiKey: Output<DataPlaneAadOrApiKeyAuthOptionArgs>? = null

    private var apiKeyOnly: Output<Any>? = null

    /**
     * @param value Indicates that either the API key or an access token from Azure Active Directory can be used for authentication.
     */
    @JvmName("hciddgheboofythc")
    public suspend fun aadOrApiKey(`value`: Output<DataPlaneAadOrApiKeyAuthOptionArgs>) {
        this.aadOrApiKey = value
    }

    /**
     * @param value Indicates that only the API key needs to be used for authentication.
     */
    @JvmName("ipyjprhakdpuuvlo")
    public suspend fun apiKeyOnly(`value`: Output<Any>) {
        this.apiKeyOnly = value
    }

    /**
     * @param value Indicates that either the API key or an access token from Azure Active Directory can be used for authentication.
     */
    @JvmName("bbnjmgoeoqsntmsr")
    public suspend fun aadOrApiKey(`value`: DataPlaneAadOrApiKeyAuthOptionArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.aadOrApiKey = mapped
    }

    /**
     * @param argument Indicates that either the API key or an access token from Azure Active Directory can be used for authentication.
     */
    @JvmName("pibugdrvglfdqjgx")
    public suspend fun aadOrApiKey(argument: suspend DataPlaneAadOrApiKeyAuthOptionArgsBuilder.() -> Unit) {
        val toBeMapped = DataPlaneAadOrApiKeyAuthOptionArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.aadOrApiKey = mapped
    }

    /**
     * @param value Indicates that only the API key needs to be used for authentication.
     */
    @JvmName("kcxiponqyfsospqd")
    public suspend fun apiKeyOnly(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.apiKeyOnly = mapped
    }

    internal fun build(): DataPlaneAuthOptionsArgs = DataPlaneAuthOptionsArgs(
        aadOrApiKey = aadOrApiKey,
        apiKeyOnly = apiKeyOnly,
    )
}
