@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.search.kotlin.inputs

import com.pulumi.azurenative.search.inputs.GetSharedPrivateLinkResourcePlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property resourceGroupName The name of the resource group within the current subscription. You can obtain this value from the Azure Resource Manager API or the portal.
 * @property searchServiceName The name of the Azure Cognitive Search service associated with the specified resource group.
 * @property sharedPrivateLinkResourceName The name of the shared private link resource managed by the Azure Cognitive Search service within the specified resource group.
 */
public data class GetSharedPrivateLinkResourcePlainArgs(
    public val resourceGroupName: String,
    public val searchServiceName: String,
    public val sharedPrivateLinkResourceName: String,
) : ConvertibleToJava<com.pulumi.azurenative.search.inputs.GetSharedPrivateLinkResourcePlainArgs> {
    override fun toJava(): com.pulumi.azurenative.search.inputs.GetSharedPrivateLinkResourcePlainArgs = com.pulumi.azurenative.search.inputs.GetSharedPrivateLinkResourcePlainArgs.builder()
        .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
        .searchServiceName(searchServiceName.let({ args0 -> args0 }))
        .sharedPrivateLinkResourceName(sharedPrivateLinkResourceName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetSharedPrivateLinkResourcePlainArgs].
 */
@PulumiTagMarker
public class GetSharedPrivateLinkResourcePlainArgsBuilder internal constructor() {
    private var resourceGroupName: String? = null

    private var searchServiceName: String? = null

    private var sharedPrivateLinkResourceName: String? = null

    /**
     * @param value The name of the resource group within the current subscription. You can obtain this value from the Azure Resource Manager API or the portal.
     */
    @JvmName("ykekmfpjcjeikquh")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the Azure Cognitive Search service associated with the specified resource group.
     */
    @JvmName("clmfppxbxeesijfm")
    public suspend fun searchServiceName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.searchServiceName = mapped
    }

    /**
     * @param value The name of the shared private link resource managed by the Azure Cognitive Search service within the specified resource group.
     */
    @JvmName("qeeddyuqvsfdjrdm")
    public suspend fun sharedPrivateLinkResourceName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.sharedPrivateLinkResourceName = mapped
    }

    internal fun build(): GetSharedPrivateLinkResourcePlainArgs =
        GetSharedPrivateLinkResourcePlainArgs(
            resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
            searchServiceName = searchServiceName ?: throw PulumiNullFieldException("searchServiceName"),
            sharedPrivateLinkResourceName = sharedPrivateLinkResourceName ?: throw
                PulumiNullFieldException("sharedPrivateLinkResourceName"),
        )
}
