@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.search.kotlin.inputs

import com.pulumi.azurenative.search.inputs.IdentityArgs.builder
import com.pulumi.azurenative.search.kotlin.enums.IdentityType
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Identity for the resource.
 * @property type The identity type.
 */
public data class IdentityArgs(
    public val type: Output<IdentityType>,
) : ConvertibleToJava<com.pulumi.azurenative.search.inputs.IdentityArgs> {
    override fun toJava(): com.pulumi.azurenative.search.inputs.IdentityArgs =
        com.pulumi.azurenative.search.inputs.IdentityArgs.builder()
            .type(type.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [IdentityArgs].
 */
@PulumiTagMarker
public class IdentityArgsBuilder internal constructor() {
    private var type: Output<IdentityType>? = null

    /**
     * @param value The identity type.
     */
    @JvmName("qfyrmnrjxuqtrhom")
    public suspend fun type(`value`: Output<IdentityType>) {
        this.type = value
    }

    /**
     * @param value The identity type.
     */
    @JvmName("sgpfvijybhshxiyj")
    public suspend fun type(`value`: IdentityType) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    internal fun build(): IdentityArgs = IdentityArgs(
        type = type ?: throw PulumiNullFieldException("type"),
    )
}
