@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.search.kotlin.inputs

import com.pulumi.azurenative.search.inputs.PrivateEndpointConnectionPropertiesPrivateLinkServiceConnectionStateArgs.builder
import com.pulumi.azurenative.search.kotlin.enums.PrivateLinkServiceConnectionStatus
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Describes the current state of an existing Private Link Service connection to the Azure Private Endpoint.
 * @property actionsRequired A description of any extra actions that may be required.
 * @property description The description for the private link service connection state.
 * @property status Status of the the private link service connection. Can be Pending, Approved, Rejected, or Disconnected.
 */
public data class PrivateEndpointConnectionPropertiesPrivateLinkServiceConnectionStateArgs(
    public val actionsRequired: Output<String>? = null,
    public val description: Output<String>? = null,
    public val status: Output<PrivateLinkServiceConnectionStatus>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.search.inputs.PrivateEndpointConnectionPropertiesPrivateLinkServiceConnectionStateArgs> {
    override fun toJava(): com.pulumi.azurenative.search.inputs.PrivateEndpointConnectionPropertiesPrivateLinkServiceConnectionStateArgs =
        com.pulumi.azurenative.search.inputs.PrivateEndpointConnectionPropertiesPrivateLinkServiceConnectionStateArgs.builder()
            .actionsRequired(actionsRequired?.applyValue({ args0 -> args0 }))
            .description(description?.applyValue({ args0 -> args0 }))
            .status(status?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [PrivateEndpointConnectionPropertiesPrivateLinkServiceConnectionStateArgs].
 */
@PulumiTagMarker
public class PrivateEndpointConnectionPropertiesPrivateLinkServiceConnectionStateArgsBuilder
internal constructor() {
    private var actionsRequired: Output<String>? = null

    private var description: Output<String>? = null

    private var status: Output<PrivateLinkServiceConnectionStatus>? = null

    /**
     * @param value A description of any extra actions that may be required.
     */
    @JvmName("uunibybdcdncueqb")
    public suspend fun actionsRequired(`value`: Output<String>) {
        this.actionsRequired = value
    }

    /**
     * @param value The description for the private link service connection state.
     */
    @JvmName("rxojfidaonhnvhql")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value Status of the the private link service connection. Can be Pending, Approved, Rejected, or Disconnected.
     */
    @JvmName("ffcebdcugjtdrqie")
    public suspend fun status(`value`: Output<PrivateLinkServiceConnectionStatus>) {
        this.status = value
    }

    /**
     * @param value A description of any extra actions that may be required.
     */
    @JvmName("ppdjpwwpjoqmmvgm")
    public suspend fun actionsRequired(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.actionsRequired = mapped
    }

    /**
     * @param value The description for the private link service connection state.
     */
    @JvmName("fupnhgsdyyoifnst")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value Status of the the private link service connection. Can be Pending, Approved, Rejected, or Disconnected.
     */
    @JvmName("jutpoehbrotfivmc")
    public suspend fun status(`value`: PrivateLinkServiceConnectionStatus?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.status = mapped
    }

    internal fun build(): PrivateEndpointConnectionPropertiesPrivateLinkServiceConnectionStateArgs =
        PrivateEndpointConnectionPropertiesPrivateLinkServiceConnectionStateArgs(
            actionsRequired = actionsRequired,
            description = description,
            status = status,
        )
}
