@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.search.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Indicates that either the API key or an access token from Azure Active Directory can be used for authentication.
 * @property aadAuthFailureMode Describes what response the data plane API of a Search service would send for requests that failed authentication.
 */
public data class DataPlaneAadOrApiKeyAuthOptionResponse(
    public val aadAuthFailureMode: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.search.outputs.DataPlaneAadOrApiKeyAuthOptionResponse): DataPlaneAadOrApiKeyAuthOptionResponse = DataPlaneAadOrApiKeyAuthOptionResponse(
            aadAuthFailureMode = javaType.aadAuthFailureMode().map({ args0 -> args0 }).orElse(null),
        )
    }
}
