@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.search.kotlin.outputs

import kotlin.Any
import kotlin.Suppress

/**
 * Defines the options for how the data plane API of a Search service authenticates requests. This cannot be set if 'disableLocalAuth' is set to true.
 * @property aadOrApiKey Indicates that either the API key or an access token from Azure Active Directory can be used for authentication.
 * @property apiKeyOnly Indicates that only the API key needs to be used for authentication.
 */
public data class DataPlaneAuthOptionsResponse(
    public val aadOrApiKey: DataPlaneAadOrApiKeyAuthOptionResponse? = null,
    public val apiKeyOnly: Any? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.search.outputs.DataPlaneAuthOptionsResponse): DataPlaneAuthOptionsResponse = DataPlaneAuthOptionsResponse(
            aadOrApiKey = javaType.aadOrApiKey().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.search.kotlin.outputs.DataPlaneAadOrApiKeyAuthOptionResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            apiKeyOnly = javaType.apiKeyOnly().map({ args0 -> args0 }).orElse(null),
        )
    }
}
