@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.search.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Identity for the resource.
 * @property principalId The principal ID of the system-assigned identity of the search service.
 * @property tenantId The tenant ID of the system-assigned identity of the search service.
 * @property type The identity type.
 */
public data class IdentityResponse(
    public val principalId: String,
    public val tenantId: String,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.search.outputs.IdentityResponse): IdentityResponse = IdentityResponse(
            principalId = javaType.principalId(),
            tenantId = javaType.tenantId(),
            type = javaType.type(),
        )
    }
}
