@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.search.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Response containing the primary and secondary admin API keys for a given Azure Cognitive Search service.
 * @property primaryKey The primary admin API key of the search service.
 * @property secondaryKey The secondary admin API key of the search service.
 */
public data class ListAdminKeyResult(
    public val primaryKey: String,
    public val secondaryKey: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.search.outputs.ListAdminKeyResult): ListAdminKeyResult = ListAdminKeyResult(
            primaryKey = javaType.primaryKey(),
            secondaryKey = javaType.secondaryKey(),
        )
    }
}
