@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.search.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Response containing the query API keys for a given Azure Cognitive Search service.
 * @property nextLink Request URL that can be used to query next page of query keys. Returned when the total number of requested query keys exceed maximum page size.
 * @property value The query keys for the Azure Cognitive Search service.
 */
public data class ListQueryKeyBySearchServiceResult(
    public val nextLink: String,
    public val `value`: List<QueryKeyResponse>,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.search.outputs.ListQueryKeyBySearchServiceResult): ListQueryKeyBySearchServiceResult = ListQueryKeyBySearchServiceResult(
            nextLink = javaType.nextLink(),
            `value` = javaType.`value`().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.search.kotlin.outputs.QueryKeyResponse.Companion.toKotlin(args0)
                })
            }),
        )
    }
}
