@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.search.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Describes the properties of an existing Private Endpoint connection to the Azure Cognitive Search service.
 * @property groupId The group id from the provider of resource the private link service connection is for.
 * @property privateEndpoint The private endpoint resource from Microsoft.Network provider.
 * @property privateLinkServiceConnectionState Describes the current state of an existing Private Link Service connection to the Azure Private Endpoint.
 * @property provisioningState The provisioning state of the private link service connection. Can be Updating, Deleting, Failed, Succeeded, or Incomplete
 */
public data class PrivateEndpointConnectionPropertiesResponse(
    public val groupId: String? = null,
    public val privateEndpoint: PrivateEndpointConnectionPropertiesResponsePrivateEndpoint? = null,
    public val privateLinkServiceConnectionState: PrivateEndpointConnectionPropertiesResponsePrivateLinkServiceConnectionState? = null,
    public val provisioningState: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.search.outputs.PrivateEndpointConnectionPropertiesResponse): PrivateEndpointConnectionPropertiesResponse = PrivateEndpointConnectionPropertiesResponse(
            groupId = javaType.groupId().map({ args0 -> args0 }).orElse(null),
            privateEndpoint = javaType.privateEndpoint().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.search.kotlin.outputs.PrivateEndpointConnectionPropertiesResponsePrivateEndpoint.Companion.toKotlin(args0)
                })
            }).orElse(null),
            privateLinkServiceConnectionState = javaType.privateLinkServiceConnectionState().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.search.kotlin.outputs.PrivateEndpointConnectionPropertiesResponsePrivateLinkServiceConnectionState.Companion.toKotlin(args0)
                })
            }).orElse(null),
            provisioningState = javaType.provisioningState().map({ args0 -> args0 }).orElse(null),
        )
    }
}
